/*
 * $Source: /opt/cvsroot/erserver/src/com/postgres/replic/tools/desc/MarkerProc.java,v $
 * $Author: ronz $ $Revision: 1.1.1.1 $ $Date: 2003/10/21 13:01:38 $
 *
 */

package com.postgres.replic.tools.desc;

import com.postgres.replic.tools.*;
import java.sql.*;

public class MarkerProc extends GeneratorDescriptor {

    public static final int REMOVE = 1;
    public static final int ADD = 2;
    
    protected int mode = T_NO;

    public static final String PROC_REMOVE = "lastchg_remove";
    public static final String PROC_ADD = "lastchg_addto";

    private AddMarkerColumn addMarker;

    public MarkerProc(boolean print, int mode) throws Exception{
        this.print = print;
        this.mode = mode;
        addMarker = new AddMarkerColumn(print);
        validateMode();
    }

    public boolean tableOnly() {
        return true;
    }

    private String getColumnName(String table) throws Exception {
        return addMarker.getColumnName(table);
    }

    private void validateMode() throws Exception {
        if (mode != REMOVE && mode != ADD) {
             throw new Exception("MarkerProc::validateMode: wrong mode=" +mode);
        }
    }

   public String getLine(String table) throws Exception {
        if (table.toLowerCase().startsWith(ToolKitConst.GLOBAL_PREFIX)) {
            return "";
        }

        String result = "";

        if (getDebug()) System.out.println("SequenceDesc::getLine mode="+mode);

        if (mode == REMOVE) {
             result = "select "  + PROC_REMOVE + "('" + table + "', '"
                + addMarker.getColumnName(table) + "', '"
                + addMarker.getFiller(table)
                + "');";
             if (getDebug()) System.out.println("MarkerProc::getLine (mode == REMOVE) > 0; result="+result);
             if (print) {
                  System.out.println(result);
             }
        }

        if (mode == ADD) {
             result = "select " + PROC_ADD + "('" + table + "', '"
                + addMarker.getColumnName(table) + "', '"
                + addMarker.getFiller(table)
                + "');";
             if (getDebug()) System.out.println("MarkerProc::getLine (mode == ADD) > 0; result="+result);
             if (print) {
                  System.out.println(result);
             }
        }
        return result;
    }
}

