#include <algorithm>
#include <cstdio>
#include <iostream>
#include <stdexcept>
#include <string>
#include <vector>

#include <pqxx/connection.h>
#include <pqxx/cursor.h>
#include <pqxx/transaction.h>
#include <pqxx/result.h>

using namespace std;
using namespace pqxx;


void DumpRows(const Result &R)
{
  for (Result::const_iterator i=R.begin(); i!=R.end(); ++i)
    cout << "\t" << i[0].c_str() << "\t" << i[1].c_str() << endl;
}


int main()
{
  Result R;

  try
  {
    Connection C("");
    Transaction T(C, "sample3");

    Cursor Cur(T, "SELECT * FROM events ORDER BY year", "tablecur", 5);

    Cur >> R;
    DumpRows(R);

    cout << endl;

    // Now read rows backwards, repositioning our cursor for each row
    for (Cursor::size_type i = 4; i >= 0; --i)
    {
      Cur.MoveTo(i);
      DumpRows(Cur.Fetch(1));
    }
  }
  catch (const exception &e)
  {
    // All exceptions thrown by libpqxx are derived from std::exception
    cerr << "Exception: " << e.what() << endl;
    return 2;
  }
  catch (...)
  {
    // This is really unexpected (see above)
    cerr << "Unhandled exception" << endl;
    return 100;
  }

  return 0;
}

