/*
 * Decompiled with CFR 0.152.
 */
package frames;

import frames.ConnectDialogListener;
import frames.PrincipalFrame;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import pgclibrary.dataaccess.MainConnection;
import pgclibrary.utilities.Utilities;

public class ConnectDialog
extends JDialog {
    PrincipalFrame frame = null;
    JTextField host = new JTextField(20);
    JTextField port = new JTextField(20);
    JTextField database = new JTextField(20);
    JTextField username = new JTextField(20);
    JPasswordField password = new JPasswordField(20);

    public ConnectDialog(PrincipalFrame _frame) {
        super((Frame)_frame, "Connect to the database");
        this.frame = _frame;
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ConnectDialog.this.close();
            }
        });
        this.getContentPane().add(this.getContents(), "Center");
        this.getContentPane().add(this.getButtons(), "South");
        this.setLocationRelativeTo(this.frame);
        this.setModal(true);
        this.pack();
    }

    private Component getContents() {
        this.port.setText(this.frame.getSystemProperties().getProperty("PORT"));
        this.host.setText(this.frame.getSystemProperties().getProperty("HOST"));
        this.database.setText(this.frame.getSystemProperties().getProperty("DATABASE"));
        this.username.setText(this.frame.getSystemProperties().getProperty("USERNAME"));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 0));
        panel1.add(new JLabel("Host: "));
        this.host.setMaximumSize(this.host.getPreferredSize());
        panel1.add(Box.createHorizontalGlue());
        panel1.add(this.host);
        panel.add(panel1);
        panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 0));
        panel1.add(new JLabel("Port: "));
        this.port.setMaximumSize(this.port.getPreferredSize());
        panel1.add(Box.createHorizontalGlue());
        panel1.add(this.port);
        panel.add(panel1);
        panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 0));
        panel1.add(new JLabel("Database: "));
        this.database.setMaximumSize(this.database.getPreferredSize());
        panel1.add(Box.createHorizontalGlue());
        panel1.add(this.database);
        panel.add(panel1);
        panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 0));
        panel1.add(new JLabel("User Name: "));
        this.username.setMaximumSize(this.username.getPreferredSize());
        panel1.add(Box.createHorizontalGlue());
        panel1.add(this.username);
        panel.add(panel1);
        panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 0));
        panel1.add(new JLabel("Password: "));
        this.password.setMaximumSize(this.password.getPreferredSize());
        panel1.add(Box.createHorizontalGlue());
        panel1.add(this.password);
        panel.add(panel1);
        return panel;
    }

    private Component getButtons() {
        ConnectDialogListener listener = new ConnectDialogListener(this);
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createHorizontalGlue());
        JButton okey = new JButton("Connect");
        okey.setActionCommand("connect");
        okey.addActionListener(listener);
        panel.add(okey);
        panel.add(Box.createHorizontalStrut(5));
        JButton cancel = new JButton("Cancel");
        cancel.setActionCommand("cancel");
        cancel.addActionListener(listener);
        panel.add(cancel);
        panel.add(Box.createHorizontalGlue());
        return panel;
    }

    private String getURI() {
        return "jdbc:postgresql://" + this.host.getText().trim() + ":" + this.port.getText().trim() + "/" + this.database.getText().trim();
    }

    protected void connect() {
        MainConnection conn = new MainConnection("org.postgresql.Driver", this.getURI(), this.username.getText().trim(), new String(this.password.getPassword()).trim());
        if (conn.isConnected()) {
            this.frame.setDatabase(conn);
            this.frame.getSystemProperties().setProperty("HOST", this.host.getText().trim());
            this.frame.getSystemProperties().setProperty("PORT", this.port.getText().trim());
            this.frame.getSystemProperties().setProperty("DATABASE", this.database.getText().trim());
            this.frame.getSystemProperties().setProperty("USERNAME", this.username.getText().trim());
            this.frame.refreshValidation();
            this.close();
        } else {
            JOptionPane.showMessageDialog(this, "The database is not accesible.\n" + Utilities.parseError(conn.getError()), "Not connected", 0);
        }
    }

    protected void close() {
        this.dispose();
    }
}

