/*
 * Decompiled with CFR 0.152.
 */
package frames;

import components.SQLTable;
import frames.SQLExecutionFrame;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;

public class SQLExecutionComponent
extends JSplitPane {
    private SQLExecutionFrame frame = null;
    private JTextPane sql_text = null;
    private SQLTable sql_result = null;
    private UndoManager undo = new UndoManager();

    public SQLExecutionComponent(SQLExecutionFrame _frame) {
        super(0);
        this.frame = _frame;
        this.sql_text = new JTextPane();
        Font tmp = new Font(this.sql_text.getFont().getFontName(), this.sql_text.getFont().getStyle(), 14);
        this.sql_text.setFont(tmp);
        this.add(new JScrollPane(this.sql_text));
        this.sql_text.getDocument().addUndoableEditListener(new MyUndoableEditListener());
        this.sql_result = new SQLTable();
        JScrollPane panel = new JScrollPane(this.sql_result);
        panel.setForeground(Color.white);
        this.add(panel);
        this.setPreferredSize(new Dimension(600, 350));
        this.setOneTouchExpandable(true);
        this.setDividerLocation(250);
    }

    public void refreshValidation() {
        if (this.frame != null) {
            boolean valid = this.frame.getPrincipalFrame().getDatabase().validate();
            this.sql_text.setEnabled(valid);
            this.sql_result.setEnabled(valid);
        }
    }

    public SQLTable getTable() {
        return this.sql_result;
    }

    public JTextPane getText() {
        return this.sql_text;
    }

    public void appendText(String _text) {
        try {
            this.sql_text.getDocument().insertString(this.sql_text.getDocument().getEndPosition().getOffset() - 1, _text, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void undo() {
        try {
            this.undo.undo();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void redo() {
        try {
            this.undo.redo();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected class MyUndoableEditListener
    implements UndoableEditListener {
        protected MyUndoableEditListener() {
        }

        public void undoableEditHappened(UndoableEditEvent e) {
            SQLExecutionComponent.this.undo.addEdit(e.getEdit());
        }
    }
}

