/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.objects;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import pgclibrary.objects.DBObject;
import pgclibrary.utilities.Utilities;

public class User
extends DBObject {
    private String password = new String();
    private boolean user_createDB = false;
    private boolean user_trace = false;
    private boolean user_super = false;
    private boolean user_captupd = false;
    private Date user_valuntil = null;

    public User(DBObject _owner, long _oid) {
        super(_owner);
        this.search(_oid);
    }

    public User(DBObject _owner) {
        super(_owner);
    }

    public String getDeleteSQL() {
        StringBuffer retorno = new StringBuffer();
        retorno.append("DROP USER ");
        retorno.append(this.getName());
        retorno.append(";\n ");
        return retorno.toString();
    }

    public String getInsertSQL() {
        StringBuffer retorno = new StringBuffer();
        retorno.append("CREATE USER ");
        retorno.append(this.getName()).append(" ");
        if (this.getPassword().length() > 0 || this.isDBCreateor() || this.isSuperUser() || this.getValidLimit() != null) {
            retorno.append("WITH ");
            if (this.getPassword().length() > 0) {
                retorno.append("PASSWORD '").append(this.getPassword()).append("' \n");
            }
            if (this.isDBCreateor()) {
                retorno.append("CREATEDB ");
            }
            if (this.isSuperUser()) {
                retorno.append("CREATEUSER ");
            }
            if (this.getValidLimit() != null) {
                retorno.append("VALID UNTIL '").append(Utilities.formatDate(this.getValidLimit(), "MMM d yyyy")).append("' ");
            }
        }
        retorno.append(";\n");
        return retorno.toString();
    }

    public String getUpdateSQL() {
        return new String();
    }

    public boolean search(long _oid) {
        boolean retorno = false;
        try {
            this.initialize();
            PreparedStatement prep = this.getConnection().prepareStatement("SELECT * FROM PG_USER WHERE USESYSID=?");
            prep.setLong(1, _oid);
            ResultSet rs = prep.executeQuery();
            if (rs.next()) {
                this.setName(rs.getString("USENAME"));
                this.setOID(rs.getLong("USESYSID"));
                this.setDBCreator(rs.getBoolean("USECREATEDB"));
                this.setTraceUser(rs.getBoolean("USECREATEDB"));
                this.setSuperUser(rs.getBoolean("USECREATEDB"));
                this.setCanUpdateSystemCatalog(rs.getBoolean("USECREATEDB"));
                this.setValidLimit(rs.getTimestamp("VALUNTIL"));
                retorno = true;
            }
            rs.close();
            prep.close();
        }
        catch (SQLException e) {
            // empty catch block
        }
        return retorno;
    }

    public void initialize() {
        super.initialize();
        this.password = new String();
        this.user_createDB = false;
        this.user_trace = false;
        this.user_super = false;
        this.user_captupd = false;
        this.user_valuntil = null;
    }

    public void setPassword(String _password) {
        this.password = _password != null ? _password : new String();
    }

    private String getPassword() {
        return this.password;
    }

    public boolean isDBCreateor() {
        return this.user_createDB;
    }

    public void setDBCreator(boolean _user_createDB) {
        this.user_createDB = _user_createDB;
    }

    public boolean isTraceUser() {
        return this.user_trace;
    }

    public void setTraceUser(boolean _user_trace) {
        this.user_trace = _user_trace;
    }

    public boolean isSuperUser() {
        return this.user_super;
    }

    public void setSuperUser(boolean _user_super) {
        this.user_super = _user_super;
    }

    public boolean canUpdateSystemCatalog() {
        return this.user_captupd;
    }

    public void setCanUpdateSystemCatalog(boolean _user_captupd) {
        this.user_captupd = _user_captupd;
    }

    public Date getValidLimit() {
        return this.user_valuntil;
    }

    public void setValidLimit(Date _until) {
        this.user_valuntil = _until != null ? _until : null;
    }

    public void setValidLimit(Timestamp _until) {
        this.user_valuntil = _until != null ? new java.sql.Date(((Date)_until).getTime()) : null;
    }
}

