/*
 * View.java
 *
 * Created on 30 de julio de 2002, 18:17
 */

package pgclibrary.objects;
import pgclibrary.dataaccess.*;
import pgclibrary.utilities.*;
import java.sql.*;
import java.util.*;

/**
 *
 * @author  nestor
 */
public class View extends DBObject {
    private String definition = new String();
    private Vector columns = null;
    
    public View(DBObject owner, long oid) {
        super(owner);
        search(oid);
    }
    public View(DBObject owner) {
        super(owner);
    }
    
    /** Retrieve the SQL string that eliminate this object from
     * the database.
     * @return SQL DML string.
     */
    public String getDeleteSQL() {
        StringBuffer retorno = new StringBuffer();
        retorno.append("DROP VIEW ");
        retorno.append(getName());
        retorno.append(";\n ");
        return retorno.toString();
    }
    
    /** Returns the SQL string that
     * generate this object.
     * @return SQL DML instruction for generation.
     */
    public String getInsertSQL() {
        return getDefinition();
    }
    
    /** Retrieve the SQL String that implements this
     * object modifications.
     * @return SQL DML String.
     */
    public String getUpdateSQL() {
        return new String();
    }
    
    /** Find the object asociated with the OID.
     * @param _oid OID to search.
     * @return true if the object was found
     */
    public boolean search(long _oid) {
        boolean retorno = false;
        try{
            initialize();
            PreparedStatement prep = getConnection().prepareStatement("SELECT OID, * FROM PG_CLASS WHERE OID=?");
            prep.setLong(1, _oid);
            ResultSet rs = prep.executeQuery();
            if(rs.next()){
                setName(rs.getString("RELNAME"));
                setOID(rs.getLong("OID"));
                setCreator(new User(this, rs.getLong("RELOWNER")));
                
                PreparedStatement prep1 = getConnection().prepareStatement("SELECT * FROM PG_VIEWS WHERE VIEWNAME=?");
                prep1.setString(1, getName());
                ResultSet rs1 = prep1.executeQuery();
                if(rs1.next()){
                    setDefinition(rs1.getString("DEFINITION"));
                    retorno = true;
                }
                rs1.close();
                prep1.close();
                retorno = true;
            }
            rs.close();
            prep.close();
        } catch (SQLException e){}
        return retorno;
    }
    
    public void initialize(){
        super.initialize();
        definition = new String();
        columns = null;
    }
    
    public dataSource getColumnsTable(){
        dataSourceVector dsve = new dataSourceVector();
        dsve.addColumnName("Col #");
        dsve.addColumnName("Name");
        dsve.addColumnName("Type");
        dsve.addColumnName("Size");
        dsve.addColumnName("Nulls");
        dsve.addColumnName("Default");
        dsve.addColumnName("Description");
        dsve.addColumnSize(10);
        dsve.addColumnSize(20);
        dsve.addColumnSize(15);
        dsve.addColumnSize(5);
        dsve.addColumnSize(5);
        dsve.addColumnSize(30);
        dsve.addColumnSize(30);
        
        Vector temp = getColumns();
        for(int i=0; i<temp.size(); i++){
            TableColumn tc = (TableColumn) temp.get(i);
            
            Vector elem = new Vector();
            elem.add(String.valueOf(tc.getColumnNumber()));
            elem.add(tc.getName());
            elem.add(tc.getColumnType().getName());
            elem.add(String.valueOf(tc.getSize()));
            elem.add(Utilities.formatBoolean(tc.allowNulls()));
            elem.add(tc.getDefaultValue());
            elem.add(tc.getDescription());
            
            dsve.addElement(elem);
        }
        return dsve;
    }
    // ------ SET AND GET --------
    private void setDefinition(String _definition){
        if(_definition != null){
            definition = _definition;
        } else {
            definition = new String();
        }
    }
    private String getDefinition(){
        return definition;
    }
    
    public Vector getColumns(){
        if(columns == null){
            columns = new Vector();
            try{
                PreparedStatement prep = getConnection().prepareStatement("select * "
                    + " from pg_attribute where ATTRELID = ? "
                    + " and attnum > 0 order by attnum");
                prep.setLong(1, getOID());
                ResultSet rs = prep.executeQuery();
                while(rs.next()){
                    columns.add(new TableColumn(this, rs.getLong("ATTNUM")));
                }
                rs.close();
                prep.close();
            } catch (SQLException e){}
        }
        return columns;
    }
}

