/*
 * ConnectDialog.java
 *
 * Created on 18 de julio de 2002, 18:25
 */

package frames;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import pgclibrary.dataaccess.*;

/**
 *
 * @author  nestor
 */
public class ConnectDialog extends JDialog {
    PrincipalFrame frame = null;
    
    JTextField host = new JTextField(20);
    JTextField port = new JTextField(20);
    JTextField database = new JTextField(20);
    JTextField username = new JTextField(20);
    JPasswordField password = new JPasswordField(20);
    
    /** Creates a new instance of ConnectDialog */
    public ConnectDialog(PrincipalFrame _frame) {
        super(_frame, "Connect to the database");
        frame = _frame;
        
        setDefaultCloseOperation(DISPOSE_ON_CLOSE);
        
        addWindowListener(new WindowAdapter(){
           public void windowClosing(WindowEvent e) {
                close();
        }});
        
        getContentPane().add(getContents(), BorderLayout.CENTER);
        getContentPane().add(getButtons(), BorderLayout.SOUTH);
        
        setLocationRelativeTo(frame);
        setModal(true);
        pack();
   }

    private Component getContents(){
        port.setText(frame.getSystemProperties().getProperty("PORT"));
        host.setText(frame.getSystemProperties().getProperty("HOST"));
        database.setText(frame.getSystemProperties().getProperty("DATABASE"));
        username.setText(frame.getSystemProperties().getProperty("USERNAME"));
        
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
        panel.setBorder(BorderFactory.createEmptyBorder(20,20,20,20));
        
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, BoxLayout.X_AXIS));
        panel1.add(new JLabel("Host: "));
        host.setMaximumSize(host.getPreferredSize());
        panel1.add(Box.createHorizontalGlue());
        panel1.add(host);
        panel.add(panel1);
        
        panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, BoxLayout.X_AXIS));
        panel1.add(new JLabel("Port: "));
        port.setMaximumSize(port.getPreferredSize());
        panel1.add(Box.createHorizontalGlue());
        panel1.add(port);
        panel.add(panel1);
        
        panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, BoxLayout.X_AXIS));
        panel1.add(new JLabel("Database: "));
        database.setMaximumSize(database.getPreferredSize());
        panel1.add(Box.createHorizontalGlue());
        panel1.add(database);
        panel.add(panel1);
        
        panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, BoxLayout.X_AXIS));
        panel1.add(new JLabel("User Name: "));
        username.setMaximumSize(username.getPreferredSize());
        panel1.add(Box.createHorizontalGlue());
        panel1.add(username);
        panel.add(panel1);

        panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, BoxLayout.X_AXIS));
        panel1.add(new JLabel("Password: "));
        password.setMaximumSize(password.getPreferredSize());
        panel1.add(Box.createHorizontalGlue());
        panel1.add(password);
        panel.add(panel1);
        
        return panel;
    }
    
    private Component getButtons(){
        ConnectDialogListener listener = new ConnectDialogListener(this);
        
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
        panel.setLayout(new BoxLayout(panel, BoxLayout.X_AXIS));

        panel.add(Box.createHorizontalGlue());
        
        JButton okey = new JButton("Connect");
        okey.setActionCommand(ConnectDialogListener.AC_CONNECT);
        okey.addActionListener(listener);
        panel.add(okey);
        
        panel.add(Box.createHorizontalStrut(5));
        
        JButton cancel = new JButton("Cancel");
        cancel.setActionCommand(ConnectDialogListener.AC_CANCEL);
        cancel.addActionListener(listener);
        panel.add(cancel);

        panel.add(Box.createHorizontalGlue());
        
        return panel;
    }
    
    private String getURI(){
        return "jdbc:postgresql://"+ host.getText().trim() + ":" + port.getText().trim() + "/" + database.getText().trim();
    }
    protected void connect(){
        MainConnection conn = new MainConnection(MainConnection.defaultDriver, getURI(), username.getText().trim(), (new String(password.getPassword())).trim());
        if(conn.isConnected()){
            frame.setDatabase(conn);
            
            frame.getSystemProperties().setProperty("HOST", host.getText().trim());
            frame.getSystemProperties().setProperty("PORT", port.getText().trim());
            frame.getSystemProperties().setProperty("DATABASE", database.getText().trim());
            frame.getSystemProperties().setProperty("USERNAME", username.getText().trim());
            
            frame.refreshValidation();
            close();
        } else {
            JOptionPane.showMessageDialog(this, "The database is not accesible.\n" + pgclibrary.utilities.Utilities.parseError(conn.getError()), "Not connected", JOptionPane.ERROR_MESSAGE);
        }
    }
    protected void close(){
        dispose();
    }
}


class ConnectDialogListener implements ActionListener {
    public static final String AC_CANCEL = "cancel";
    public static final String AC_CONNECT = "connect";
    
    private ConnectDialog frame = null;
    
    /** Creates a new instance of PrincipalFrame_listener */
    public ConnectDialogListener(ConnectDialog _frame){
        frame = _frame;
    }
    
    public void actionPerformed(java.awt.event.ActionEvent actionEvent) {
        if(actionEvent.getActionCommand().equals(AC_CANCEL)){
            frame.close();
        }
        if(actionEvent.getActionCommand().equals(AC_CONNECT)){
            frame.connect();
        }
    }
}


