/* $Id: numeric.h,v 1.1 2005/10/21 21:54:55 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * Interface to numeric types
 */
#ifndef PyPg_type_numeric_H
#define PyPg_type_numeric_H 0
#ifdef __cplusplus
extern "C" {
#endif

IF_PGTYPE_INT2(extern PyPgTypeObject PyPg_int2_Type;)
IF_PGTYPE_INT4(extern PyPgTypeObject PyPg_int4_Type;)
IF_PGTYPE_INT8(extern PyPgTypeObject PyPg_int8_Type;)
IF_PGTYPE_FLOAT4(extern PyPgTypeObject PyPg_float4_Type;)
IF_PGTYPE_FLOAT8(extern PyPgTypeObject PyPg_float8_Type;)
IF_PGTYPE_NUMERIC(extern PyPgTypeObject PyPg_numeric_Type;)
IF_PGTYPE_CASH(extern PyPgTypeObject PyPg_cash_Type;)

#define PyPg_int2_Check(SELF) \
	(PyObject_TypeCheck((SELF), &PyPg_int2_Type))
#define PyPg_int2_CheckExact(SELF) ((SELF)->ob_type == &PyPg_int2_Type)

#define PyPg_int4_Check(SELF) \
	(PyObject_TypeCheck((SELF), &PyPg_int4_Type))
#define PyPg_int4_CheckExact(SELF) ((SELF)->ob_type == &PyPg_int4_Type)

#define PyPg_int8_Check(SELF) \
	(PyObject_TypeCheck((SELF), &PyPg_int8_Type))
#define PyPg_int8_CheckExact(SELF) ((SELF)->ob_type == &PyPg_int8_Type)

#define PyPg_float4_Check(SELF) \
	(PyObject_TypeCheck((SELF), &PyPg_float4_Type))
#define PyPg_float4_CheckExact(SELF) ((SELF)->ob_type == &PyPg_float4_Type)

#define PyPg_float8_Check(SELF) \
	(PyObject_TypeCheck((SELF), &PyPg_float8_Type))
#define PyPg_float8_CheckExact(SELF) ((SELF)->ob_type == &PyPg_float8_Type)

#define PyPg_numeric_Check(SELF) \
	(PyObject_TypeCheck((SELF), &PyPg_numeric_Type))
#define PyPg_numeric_CheckExact(SELF) ((SELF)->ob_type == &PyPg_numeric_Type)

#define PyPg_cash_Check(SELF) \
	(PyObject_TypeCheck((SELF), &PyPg_cash_Type))
#define PyPg_cash_CheckExact(SELF) ((SELF)->ob_type == &PyPg_cash_Type)

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_type_numeric_H */
/*
 * vim: ts=3:sw=3:noet:
 */
