.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "SPI_push" "" "2010-05-14" "" "PostgreSQL 8.1.21 Documentation"
.SH NAME
SPI_push \- push SPI stack to allow recursive SPI usage

.SH SYNOPSIS
.sp
.nf
void SPI_push(void)
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBSPI_push\fR should be called before executing another
procedure that might itself wish to use SPI.
After \fBSPI_push\fR, SPI is no longer in a
``connected'' state, and SPI function calls will be rejected unless
a fresh \fBSPI_connect\fR is done. This ensures a clean
separation between your procedure's SPI state and that of another procedure
you call. After the other procedure returns, call
\fBSPI_pop\fR to restore access to your own SPI state.
.PP
Note that \fBSPI_execute\fR and related functions
automatically do the equivalent of \fBSPI_push\fR before
passing control back to the SQL execution engine, so it is not necessary
for you to worry about this when using those functions.
Only when you are directly calling arbitrary code that might contain
\fBSPI_connect\fR calls do you need to issue
\fBSPI_push\fR and \fBSPI_pop\fR.
