.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "DROP TEXT SEARCH PARSER" "" "2012-09-19" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP TEXT SEARCH PARSER \- remove a text search parser

.SH SYNOPSIS
.sp
.nf
DROP TEXT SEARCH PARSER [ IF EXISTS ] \fIname\fR [ CASCADE | RESTRICT ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBDROP TEXT SEARCH PARSER\fR drops an existing text search
parser. You must be a superuser to use this command.
.SH "PARAMETERS"
.TP
\fBIF EXISTS\fR
Do not throw an error if the text search parser does not exist.
A notice is issued in this case.
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of an existing text search parser.
.TP
\fBCASCADE\fR
Automatically drop objects that depend on the text search parser.
.TP
\fBRESTRICT\fR
Refuse to drop the text search parser if any objects depend on it.
This is the default.
.SH "EXAMPLES"
.PP
Remove the text search parser my_parser:
.sp
.nf
DROP TEXT SEARCH PARSER my_parser;
.sp
.fi
This command will not succeed if there are any existing text search
configurations that use the parser. Add CASCADE to
drop such configurations along with the parser.
.SH "COMPATIBILITY"
.PP
There is no \fBDROP TEXT SEARCH PARSER\fR statement in the
SQL standard.
.SH "SEE ALSO"
ALTER TEXT SEARCH PARSER [\fBalter_text_search_parser\fR(l)], CREATE TEXT SEARCH PARSER [\fBcreate_text_search_parser\fR(l)]
