.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "RELEASE SAVEPOINT" "" "2012-09-19" "SQL - Language Statements" "SQL Commands"
.SH NAME
RELEASE SAVEPOINT \- destroy a previously defined savepoint

.SH SYNOPSIS
.sp
.nf
RELEASE [ SAVEPOINT ] \fIsavepoint_name\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBRELEASE SAVEPOINT\fR destroys a savepoint previously defined
in the current transaction.
.PP
Destroying a savepoint makes it unavailable as a rollback point,
but it has no other user visible behavior. It does not undo the
effects of commands executed after the savepoint was established.
(To do that, see ROLLBACK TO SAVEPOINT [\fBrollback_to_savepoint\fR(l)].) Destroying a savepoint when
it is no longer needed allows the system to reclaim some resources
earlier than transaction end.
.PP
\fBRELEASE SAVEPOINT\fR also destroys all savepoints that were
established after the named savepoint was established.
.SH "PARAMETERS"
.TP
\fB\fIsavepoint_name\fB\fR
The name of the savepoint to destroy.
.SH "NOTES"
.PP
Specifying a savepoint name that was not previously defined is an error.
.PP
It is not possible to release a savepoint when the transaction is in
an aborted state.
.PP
If multiple savepoints have the same name, only the one that was most
recently defined is released.
.SH "EXAMPLES"
.PP
To establish and later destroy a savepoint:
.sp
.nf
BEGIN;
    INSERT INTO table1 VALUES (3);
    SAVEPOINT my_savepoint;
    INSERT INTO table1 VALUES (4);
    RELEASE SAVEPOINT my_savepoint;
COMMIT;
.sp
.fi
The above transaction will insert both 3 and 4.
.SH "COMPATIBILITY"
.PP
This command conforms to the SQL standard. The standard
specifies that the key word SAVEPOINT is
mandatory, but PostgreSQL allows it to
be omitted.
.SH "SEE ALSO"
BEGIN [\fBbegin\fR(l)], COMMIT [\fBcommit\fR(l)], ROLLBACK [\fBrollback\fR(l)], ROLLBACK TO SAVEPOINT [\fBrollback_to_savepoint\fR(l)], SAVEPOINT [\fBsavepoint\fR(l)]
