/************************************************************************/
/*                                                                      */
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998  NORD><LINK e.V. Braunschweig                     */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fr     */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fr Amateurfunk Software).                                           */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fr Amateurfunk Software) along with this program; if not,    */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-3300 Braunschweig    */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschrnkungen durch     */
/* die ALAS (Allgemeine Lizenz fr Amateurfunk Software), entweder      */
/* Version 1, verffentlicht von Hans Georg Giese (DF2AU),              */
/* am 13.Oct.1992, oder (wenn gewnscht) jede sptere Version.          */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschlu vertrieben, aus-        */
/* schlielich fr Weiterentwicklungs- und Lehrzwecke. Nheres          */
/* knnen sie der ALAS (Allgemeine Lizenz fr Amateurfunk Software)     */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fr Amateurfunk */
/* Software) beigelegen haben, wenden Sie sich bitte an                 */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/*                                                                      */
/************************************************************************/

#include "tnn.h"

/*------------------------------------------------------------------------*/
/*
 *      Statische Variablen und Funktionen nur fuer L2DAMA.C
 */

static WORD      dama_timer;

static void      xmit_damail(WORD *);
static void      xmit_damarl(int, WORD *);


/*------------------------------------------------------------------------*/
/*      DAMA Initialisierung (Aufruf von l2init())                        */
/*------------------------------------------------------------------------*/
void iniDAMA(void)
{
  WORD i;

  dama_timer = 0;
  
  for (i = 0; i < L2PNUM; i++)
    inithd(&damarl[i]);

  for (i = 0, lnkpoi = lnktbl; i < LINKNMBR; ++i, ++lnkpoi)
  {
    inithd(&lnkpoi->damail);
    lnkpoi->pollcnt = 0;       /* Anzahl verbotener Polls des DAMA-Users */
    lnkpoi->priold = -1;       /* Link-Prioritts-Merker/Flag            */
    lnkpoi->indx = 1;          /* Index des Multiconnect                 */
    lnkpoi->zael = 1;          /* Aktiver Multiconnect                   */
    lnkpoi->anzl = 0;          /* Anzahl der Verbindungen bisher         */
    clrDAMA();
  }
}

/*--------------------------------------------------------------------------
 *
 *      Feststellen, ob auf einem der Kanaele der Sender getastet
 *      ist, oder ein User noch etwas antwortet.
 *
 *-------------------------------------------------------------------------*/
int dama_dcd(void)
#define NO_DAMA     2
#define DAMA_DCD    1
#define DAMA_NO_DCD 0
{
  int port;
  int state = NO_DAMA;
  PORTINFO *pp;

  for (port = 0, pp = portpar;             /* Alle DAMA-Ports pruefen..  */
       port < L2PNUM;
       port++, pp++) {
    if (dama(port)) {                      /* nur die DAMA-Ports         */
      if (iscd(port))                      /* nicht busy(), iscd() !     */
        return (DAMA_DCD);
      state = DAMA_NO_DCD;
    }
  }
  return (state);
}

/*----------------------------------------------------------------------*/
/* Wenn Info zu senden, gemaess Fenster passende Zahl an I-Frames in    */
/* die Dama-Sendeliste des aktiven Links (lnkpoi) haengen - das         */
/* passiert tatsaechlich in sdi / sdl2fr                                */
/*----------------------------------------------------------------------*/
BOOLEAN damatx(void)
{
  int       n;

  if (lnkpoi->tosend) {                      /* was zu senden?          */
    if ((n = itxwnd()) > 0) {                /* Fenster noch offen?     */
      sdi(outsdI(), n);                      /* Frames generieren       */
      lnkpoi->priold = lnkpoi->damapm;       /* akt. Priori. merken     */
      clrDAMA();                             /* DAMA-Parameter clear    */
      return (TRUE);
    }
  }
  return (FALSE);                            /* wir haben nix gesendet  */
}


/*----------------------------------------------------------------------*/
/* Daten aus der Dama-Sendeliste des aktiven Links (lnkpoi)             */
/* tatsaechlich aussenden - diese Funktion wird nur aufgerufen, wenn    */
/* der Link auch senden darf                                            */
/*----------------------------------------------------------------------*/
static void
xmit_damail(WORD *txflag)
{
  MBHEAD *fbp;
  
  while (   (fbp = (MBHEAD *) lnkpoi->damail.head)
         != (MBHEAD *) &lnkpoi->damail)
   {                                    /* sind noch Frames da ?        */
    ulink((LEHEAD *)fbp);               /* ja:                          */
    relink((LEHEAD *)fbp,(LEHEAD *)txl2fl[lnkpoi->liport].tail);
    kicktx(lnkpoi->liport);             /* Frame markieren              */
    lnkpoi->flag |= (L2FDAMA1+L2FDAMA2);/* DAMA Flag Bit 1 & 2 setzen   */
    lnkpoi->flag |= L2FDACK;            /* Bestaetigungs-Flag setzen    */
    *txflag = 1;                        /* was da, TX-Flag setzen !     */
    dama_timer = dama_init;             /* DAMA-Timer wieder setzen     */
   }
}

/*----------------------------------------------------------------------*/
/* Daten aus der Dama-Random-Liste des angegebenen Ports tatsaechlich   */
/* aussenden.                                                           */
/*----------------------------------------------------------------------*/
static void
xmit_damarl(int port, WORD *txflag)
{
  MBHEAD *fbp;
  
  while (   (fbp = (MBHEAD *) damarl[port].head)
         != (MBHEAD *) &damarl[port])
   {                                    /* sind noch Frames da ?        */
    ulink((LEHEAD *)fbp);               /* ja:                          */
    relink((LEHEAD *)fbp,(LEHEAD *)txl2fl[port].tail);
    kicktx(port);                       /* Frame markieren              */
    *txflag = 1;                        /* was da, TX-Flag setzen !     */
   }
}

/*--------------------------------------------------------------------------
 *
 *      DAMA-Timer abhaengige Funktionen ausfueheren
 *
 *      Aufruf erfolgt von l2timr().
 *
 *      Funktion:
 *      dama_timer um ticks vermindern; wenn DAMA-Betrieb freigegeben und
 *      dama_timer abgelaufen, dann L2-Link-Tabelle nach DAMA-Uplink durch-
 *      suchen und, falls Info vorliegt I-Frames, sonst Poll senden.
 *      Anschliessend diesen Uplink als bearbeitet markieren.
 *      Dabei jeden User nur einmal pro Runde an die Reihe nehmen !
 *
 *-------------------------------------------------------------------------*/

void timDAMA(UWORD ticks)
{
  WORD     i;
  WORD     txflag;
  WORD     dsf;
  LHEAD   *llp;
  WORD     port;
  int      dcd;

  if ((dcd = dama_dcd()) == NO_DAMA)          /* kein DAMA Port            */
    return;

  dcd &= 1;                                   /* DCD extrahieren           */

  if ( !dcd && (dama_timer > 0) )             /* Frequenz (DCD) frei und   */
  {                                           /* DAMA-Timer abgelaufen ?   */
    if (dama_timer <= ticks)
      dama_timer = 0;
    else                                      /* DAMA-Zaehler runterzaehlen*/
      dama_timer -= ticks;
  }

  if (dama_timer == 0)                        /* DAMA-Timer abgelaufen?     */
  {
    if (!dcd)        /* DAMA nur weiter, wenn letztes Frame gesendet wurde  */
     {
      txflag = 0;                             /* TX-Flag clear              */
      for (port = 0; port < L2PNUM; port++)
        xmit_damarl(port, &txflag);
     }
    
    if (!dcd && txflag == 0)
    {                                         /*          (Carrier detect)  */
      for (i = 0, lnkpoi = lnktbl; i < LINKNMBR; ++i, ++lnkpoi)
      {                                       /* alle Links nacheinander    */
        lnkpoi->flag &= ~L2FDAMA2;            /* DAMA Flag Bit 2 loeschen ! */
        if (lnkpoi->state == L2SDSCED) continue;
        if (dama(lnkpoi->liport)) {           /* DAMA-Link ?                */
          if ((lnkpoi->flag & L2FDAMA1) == 0) /* DAMA-Flag Bit 1 geloescht ?*/
          {                                   /* ja: war noch nicht drann ! */
            lnkpoi->flag |= L2FDAMA1;         /* DAMA Flag Bit 1 setzen !   */
                                              /* als "dran" kennzeichnen    */
            if (lnkpoi->zael == lnkpoi->indx) /* hat Link Sende-Erlaubnis ? */
            {
              if (damatx() == FALSE)          /* Neue I-Frames generieren  */
                if (    lnkpoi->damapm == 0   /* Nur bei hchster Priori.  */
                     && lnkpoi->damapc == 0 ) /* pG: 23.8.95               */
                  if (    (MBHEAD *)  lnkpoi->damail.head
                       == (MBHEAD *) &lnkpoi->damail
                     )                        /* Warten auf Besttigung    */
                  {                           /* oder nix in der Liste ?   */
                    l2stma(stbl23);           /* ja: dann gleich pollen    */
                    incDAMA();                /*     und Prioritt runter  */
                  }

              xmit_damail(&txflag);
              break;                       /* DAMA User gefunden, abbrechen */
            }   /* Sende-Erlaubnis ? */
          }     /* DAMA-Flag Bit 1 geloescht ? */
        }       /* DAMA-Port ? */
      }         /* alle Links  */

      if (i < LINKNMBR && txflag == 0)
      {
       /*
        * Keine Info zum senden gefunden, also Poll senden !
        * ====> leere Polls ???
        */
                /* Zeit abgelaufen und Link an der Reihe? */
        if ( lnkpoi->damapc == 0 && lnkpoi->zael == lnkpoi->indx )
        {                                    /* auch nur EIN Poll pro Runde */
          ++lnkpoi->tries;                   /* Tries erhoehen              */
          incDAMA();                         /* Prioritaet runtersetzen     */
          if ( lnkpoi->tries < portpar[lnkpoi->liport].retry )
          {
            l2stma(stbl23);     /* bei AX25 V2.0 : T1 expires  (fuer Poll)  */
          }
          else
          {
            lnkpoi->tries = 0;                    /* Tries abgelaufen !     */
            l2stma(stbl25);                       /* N2 IS EXCEEDED         */
          }
          xmit_damail(&txflag);
        } /* DAMA && Sende-Genehmigung */
      } /* lnkpoi != && txflag == 0 */

      if (i == LINKNMBR)
      {
       /*
        * Keinen zu bearbeitenden DAMA-Link gefunden, oder schon
        * alle DAMA-Links bearbeitet . Also ist die Runde zuende !
        * DAMA-Flags loeschen und Prioritaetszaehler runterzaehlen.
        * Leere Polls auf MC-Links durch IXFER ersetzen.
        */

        /* DAMA-Flags loeschen */
        for (llp = &l2actl[port = 0];
             port < L2PNUM;
             port++, llp++)
          if (dama(port))
            for (lnkpoi  = (LNKBLK *)llp->head;
                 lnkpoi != (LNKBLK *)llp;
                 lnkpoi  = lnkpoi->next) {
              lnkpoi->flag &= ~(L2FDAMA1+L2FDAMA2); /* DAMA Flag Bit 1 & 2 loeschen */
              /*
               * Naechsten MC-Link freigeben (zael erhoehen)
               * DAMA-Speed-Faktor beachten.
               */
               if (( dsf = (DamaSpeedFactor/100)/portpar[lnkpoi->liport].speed ) < 1 )
                 dsf = 1;

               if (lnkpoi->zael < lnkpoi->anzl * dsf) /* Zaehler aktualisieren*/
                 lnkpoi->zael++;
               else
                 lnkpoi->zael = 1;
            }
      }
    }      /* Frequenz frei? */
  }        /* DAMA-Timer abgelaufen ?  */

  /*
   * Bei jedem Aufruf von timDAMA() die DAMA-Prioritaet um ticks
   * herunterzaehlen
   */

  for (llp = &l2actl[port = 0];     /* alle Ports durchgehen            */
       port < L2PNUM;
       port++, llp++)
    if (dama(port))                 /* nur wenns ein DAMA-Port ist      */
      for (lnkpoi  = (LNKBLK *)llp->head;
           lnkpoi != (LNKBLK *)llp;
           lnkpoi  = lnkpoi->next)
        if (lnkpoi->damapc >= ticks)
          lnkpoi->damapc -= ticks;
        else
          lnkpoi->damapc = 0;
}


/*------------------------------------------------------------------------*/
/*
 *      DAMA Aktivitaetszaehler und -merker auf 0 setzen
 *      (wenn User I-Frames gesendet hat)
 */

void clrDAMA()
{
  lnkpoi->damapm = 0;
  lnkpoi->damapc = 0;
}

/*------------------------------------------------------------------------*/
/*
 *      DAMA Aktivitaetszaehler auf Wert von Aktivitaetsmerker setzen
 *      Prioritaet in Sekunden zuzueglich 2 Sekunden
 *
 */

void setDAMA()
{
  lnkpoi->damapc = lnkpoi->damapm *100;
}

/*------------------------------------------------------------------------*/
/*      DAMA Aktivitaetsmerker inkrementieren                             */
/*      Reduzierung der Poll-Rate auf 1min. nach 10min. Inaktivitaet.     */
/*------------------------------------------------------------------------*/
void incDAMA()
{
  if (lnkpoi->damapm < dama_max)
    ++lnkpoi->damapm;

  if (     lnkpoi->noatou > (ininat-600)       /* Keine Aktivitaet??      */
        || lnkpoi->tries > 1             )     /* Bei Retries schneller.. */
    lnkpoi->damapc = lnkpoi->damapm * 100;     /* Prioritaet normal..     */
  else
    lnkpoi->damapc = 6000;                     /* Prioritaet auf 1 Minute */
}

/*------------------------------------------------------------------------*/
/*
 *      DAMA Timer loeschen
 */

void clearDT(UWORD time)
{
  if (dama(lnkpoi->liport) && (lnkpoi->flag & (L2FDAMA1+L2FDAMA2)) == (L2FDAMA1+L2FDAMA2))
  {
    lnkpoi->flag &= ~L2FDAMA2;
    lnkpoi->tries = 0;
    dama_timer = time;
  }
}


/*------------------------------------------------------------------------*/
/* POLL-Frames von Usern sind bei DAMA verboten und werden angemeckert.   */
/* Zunaechst wird eine Warnung verschickt, dann ein Disconnect.           */
/*------------------------------------------------------------------------*/
void polDAMA(void)
{
  MBHEAD *mbp;
  MHEARD *mhp;

  if (lnkpoi->state != L2SDSCED)      /* Wenn es ein aktiver Link ist..   */
  {
    lnkpoi->pollcnt++;          /* Neuen Versto mitzaehlen..             */
    if ((mhp = mh_lookup(&l2heard, lnkpoi->dstid)) != NULL)
      mhp->damawarn++;

    if (MaxPollCnt)             /* DAMA-Kontrolle eingeschaltet?          */
    {
      /*..................................................................*/
      /* Anzahl der maximal zugelassenen Verstoee ueberschritten, es folgt*/
      /* Fehlermeldung und Zwangsdisconnect!!!                            */
      /*..................................................................*/
      mbp = (MBHEAD *) allocb();                /* Buffer besorgen..      */
      mbp->l2link = lnkpoi;                     /* Linkpointer und        */
      mbp->type = 2;
      putprintf(mbp, "\r*** from DAMA-Master ", myid);
      putcal(myid,mbp);                         /* Digi-Call ausgeben     */
      if (lnkpoi->pollcnt >= MaxPollCnt)
      {
        /*dealml((LEHEAD *)&lnkpoi->sendil); */ /* Sende-Liste lschen    */
        /*lnkpoi->tosend = 0;                */ /* kein Frame zu senden   */

        /* Das loeschen der Sende-Liste ist nicht ganz ungefhrlich, je   */
        /* nach dem, in welchen State wir gerade sind, lieber den Schrott */
        /* senden und dann abwerfen, DB7KG                                */

        putprintf(mbp, "> DISCONNECT: Too many non-DAMA Polls (%u) !!\r",
                       lnkpoi->pollcnt);        /* Verstoesse ausgeben    */
        seteom(mbp);
        dsclnk();                               /* Disconnect einleiten   */
      }
      else
      {                                         /* Vorwarnung!            */
        putprintf(mbp, "> WARNING: non-DAMA Poll #%u, Disconnect after %u !!\r",
                       lnkpoi->pollcnt, MaxPollCnt);
        seteom(mbp);
      }
    }
  }
}

/**************************************************************************
 *
 * ====> "IXFER on Multi-Connect Links ?"
 *
 * ====> Diese neue Routine prueft, ob eine DAMA Multi-Connect-Station auf
 *       einem ihrer Links noch L2-Info-Transfer (L2SIXFER mit hoechster
 *       Prioritaet = 0) anstehen hat.
 *       wenn ja:  Rueckgabewert TRUE     wenn nicht: FALSE
 **************************************************************************/
BOOLEAN IXFERonMC (void)
{
  LNKBLK  *lp;
  LHEAD   *llp;
  WORD     port;
  char    *id = lnkpoi->dstid;

  for (llp = &l2actl[port = 0];     /* alle Ports durchgehen            */
       port < L2PNUM;
       port++, llp++)
    if (dama(port))                 /* nur wenns ein DAMA-Port ist      */
      for (lp  = (LNKBLK *)llp->head;
           lp != (LNKBLK *)llp;
           lp  = lp->next)
        if (   cmpcal (lp->dstid,id)         /* ist es das Call         */
            && lp->state == L2SIXFER         /* und Info-Transfer       */
            && lp->damapm == 0               /* mit hoher Prioritaet    */
           )
          return (TRUE);                     /* ja !                    */
  return (FALSE);
}


/**************************************************************************
 *
 *  "get Multi Connect Tabels"
 *
 *      "getMCs" wird jedesmal aufgerufen, wenn ein neuer L2-Link dazukommt
 *       oder abgemeldet wird. (Connect/Disconnect)
 *
 *      "getMCs" stellt DAMA Multi-Connects (MC's) fest und baut die Multi-
 *       Connect-Tabellen lnkpoi->indz und lnkpoi->anzl auf und korregiert
 *       lnkpoi->zael bei Link-Aenderungen auf plausible Werte.
 *
 *       lnkpoi->indz repraesentiert die Indizes einer MC-Station.
 *       lnkpoi->anzl repraesentiert die Anzahl der MC's einer Station.
 *
 *       lnkpoi->zael wird dann nach jeder Runde erhoeht bzw. zurueckgesetzt.
 *       Bei Gleichheit von indz und zael erhaelt dieser Link spaeter die
 *       "Sende-Erlaubnis" !
 *
 *       NEU: getMCs wird nur noch aufgerufen, wenn wirklich noetig
 *            (in L2B in l2newstate). getMCs arbeitet jetzt LINEAR.
 *
 **************************************************************************/
#pragma argsused
void getMCs(void)
{
  WORD       multi, indx, port;
  LHEAD     *llp;
  LNKBLK    *lp;
  char      *id;

  lnkpoi->zael = 1;                 /* Zaehler immer zurueck            */

  id = lnkpoi->dstid;               /* geht etwas schneller             */

  multi = 0;
  for (llp = &l2actl[port = 0];     /* alle Ports durchgehen            */
       port < L2PNUM;
       port++, llp++)
    if (dama(port))                 /* nur wenns ein DAMA-Port ist      */
      for (lp  = (LNKBLK *)llp->head;
           lp != (LNKBLK *)llp;
           lp  = lp->next)
        if (cmpcal(lp->dstid,id))
          multi++;

  if (   (!dama(lnkpoi->liport))              /* kein DAMA-Link?           */
      || (!multi))                            /* oder letzter MultiConnect */
  {
    lnkpoi->indx = 1;                         /* Index zuruecksetzen !     */
    lnkpoi->anzl = 0;                         /* Anzahl der Verbindungen ! */
    return;
  }

  /*
   * Hinweis zum Ablauf:
   * Die Linkliste wird durchlaufen und fuer jeden Multiconnect-Link
   * die Anzahl der aktiven Multiconnects (->anzl) und ein Index gesetzt.
   * Der aktuelle Link (lnkpoi) wird hier auch gefunden und behandelt,
   * sofern dies noetig ist (L2MCONN).
   */

  indx = 0;
  for (llp = &l2actl[port = 0];     /* alle Ports durchgehen            */
       port < L2PNUM;
       port++, llp++)
    if (dama(port))                 /* nur wenns ein DAMA-Port ist      */
      for (lp  = (LNKBLK *)llp->head;
           lp != (LNKBLK *)llp;
           lp  = lp->next)
        if (cmpcal(lp->dstid,id)) { /* gleiches Call ?                  */
          lp->indx = ++indx;        /* Index setzen                     */
          lp->anzl = multi;         /* Anzahl der Connects              */
        }
}

/* End of L2DAMA.C */
