/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.server.namenode.JspHelper;
import org.apache.hadoop.http.HtmlQuoting;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.ServletUtil;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspSourceDependent;
import org.apache.jasper.runtime.ResourceInjector;

public final class tail_jsp
extends HttpJspBase
implements JspSourceDependent {
    static JspHelper jspHelper = new JspHelper();
    private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();
    private static Vector _jspx_dependants;
    private ResourceInjector _jspx_resourceInjector;

    public void generateFileChunks(JspWriter out, HttpServletRequest req, Configuration conf) throws IOException, InterruptedException {
        DatanodeInfo chosenNode;
        String chunkSizeToViewStr;
        String filename;
        long startOffset = 0L;
        int chunkSizeToView = 0;
        String tokenString = req.getParameter("delegation");
        String referrer = req.getParameter("referrer");
        boolean noLink = false;
        if (referrer == null) {
            noLink = true;
        }
        if ((filename = HtmlQuoting.unquoteHtmlChars(req.getParameter("filename"))) == null) {
            out.print("Invalid input (file name absent)");
            return;
        }
        String namenodeInfoPortStr = req.getParameter("namenodeInfoPort");
        int namenodeInfoPort = -1;
        if (namenodeInfoPortStr != null) {
            namenodeInfoPort = Integer.parseInt(namenodeInfoPortStr);
        }
        chunkSizeToView = (chunkSizeToViewStr = req.getParameter("chunkSizeToView")) != null && Integer.parseInt(chunkSizeToViewStr) > 0 ? Integer.parseInt(chunkSizeToViewStr) : JspHelper.getDefaultChunkSize(conf);
        if (!noLink) {
            out.print("<h3>Tail of File: ");
            JspHelper.printPathWithLinks(HtmlQuoting.quoteHtmlChars(filename), out, namenodeInfoPort, tokenString);
            out.print("</h3><hr>");
            out.print("<a href=\"" + referrer + "\">Go Back to File View</a><hr>");
        } else {
            out.print("<h3>" + HtmlQuoting.quoteHtmlChars(filename) + "</h3>");
        }
        out.print("<b>Chunk size to view (in bytes, up to file's DFS block size): </b>");
        out.print("<input type=\"text\" name=\"chunkSizeToView\" value=" + chunkSizeToView + " size=10 maxlength=10>");
        out.print("&nbsp;&nbsp;<input type=\"submit\" name=\"submit\" value=\"Refresh\"><hr>");
        out.print("<input type=\"hidden\" name=\"filename\" value=\"" + HtmlQuoting.quoteHtmlChars(filename) + "\">");
        out.print("<input type=\"hidden\" name=\"namenodeInfoPort\" value=\"" + namenodeInfoPort + "\">");
        if (!noLink) {
            out.print("<input type=\"hidden\" name=\"referrer\" value=\"" + referrer + "\">");
        }
        UserGroupInformation ugi = JspHelper.getUGI(req, conf);
        DFSClient dfs = JspHelper.getDFSClient(ugi, JspHelper.nameNodeAddr, conf);
        List<LocatedBlock> blocks = dfs.namenode.getBlockLocations(filename, 0L, Long.MAX_VALUE).getLocatedBlocks();
        if (blocks == null || blocks.size() == 0) {
            out.print("No datanodes contain blocks of file " + filename);
            dfs.close();
            return;
        }
        LocatedBlock lastBlk = blocks.get(blocks.size() - 1);
        long blockSize = lastBlk.getBlock().getNumBytes();
        long blockId = lastBlk.getBlock().getBlockId();
        Token<BlockTokenIdentifier> accessToken = lastBlk.getBlockToken();
        long genStamp = lastBlk.getBlock().getGenerationStamp();
        try {
            chosenNode = JspHelper.bestNode(lastBlk);
        }
        catch (IOException e) {
            out.print(e.toString());
            dfs.close();
            return;
        }
        InetSocketAddress addr = NetUtils.createSocketAddr(chosenNode.getName());
        startOffset = blockSize >= (long)chunkSizeToView ? blockSize - (long)chunkSizeToView : 0L;
        out.print("<textarea cols=\"100\" rows=\"25\" wrap=\"virtual\" style=\"width:100%\" READONLY>");
        jspHelper.streamBlockInAscii(addr, blockId, accessToken, genStamp, blockSize, startOffset, chunkSizeToView, out, conf);
        out.print("</textarea>");
        dfs.close();
    }

    @Override
    public Object getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        PageContext pageContext = null;
        HttpSession session = null;
        ServletContext application = null;
        ServletConfig config = null;
        JspWriter out = null;
        tail_jsp page = this;
        JspWriter _jspx_out = null;
        PageContext _jspx_page_context = null;
        try {
            response.setContentType("text/html; charset=UTF-8");
            _jspx_page_context = pageContext = _jspxFactory.getPageContext(this, request, response, null, true, 8192, true);
            application = pageContext.getServletContext();
            config = pageContext.getServletConfig();
            session = pageContext.getSession();
            _jspx_out = out = pageContext.getOut();
            this._jspx_resourceInjector = (ResourceInjector)application.getAttribute("com.sun.appserv.jsp.resource.injector");
            out.write("\n\n\n");
            out.write("\n\n\n\n<!DOCTYPE html>\n<html>\n<head>\n");
            JspHelper.createTitle(out, request, request.getParameter("filename"));
            out.write("\n</head>\n<body>\n<form action=\"/tail.jsp\" method=\"GET\">\n");
            Configuration conf = (Configuration)application.getAttribute("current.conf");
            this.generateFileChunks(out, request, conf);
            out.write("\n</form>\n<hr>\n\n<h2>Local logs</h2>\n<a href=\"/logs/\">Log</a> directory\n\n");
            out.println(ServletUtil.htmlFooter());
            out.write(10);
            _jspxFactory.releasePageContext(_jspx_page_context);
        }
        catch (Throwable t) {
            try {
                if (!(t instanceof SkipPageException)) {
                    out = _jspx_out;
                    if (out != null && out.getBufferSize() != 0) {
                        out.clearBuffer();
                    }
                    if (_jspx_page_context != null) {
                        _jspx_page_context.handlePageException(t);
                    }
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                _jspxFactory.releasePageContext(_jspx_page_context);
            }
        }
    }
}

