/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi.impl;

import jakarta.faces.context.ExternalContext;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.spi.FaceletConfigResourceProvider;
import org.apache.myfaces.spi.FaceletConfigResourceProviderFactory;
import org.apache.myfaces.spi.ServiceProviderFinderFactory;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.view.facelets.compiler.DefaultFaceletConfigResourceProvider;

public class DefaultFaceletConfigResourceProviderFactory
extends FaceletConfigResourceProviderFactory {
    public static final String FACELET_CONFIG_PROVIDER = FaceletConfigResourceProvider.class.getName();
    public static final String FACELET_CONFIG_PROVIDER_LIST = FaceletConfigResourceProvider.class.getName() + ".LIST";

    private Logger getLogger() {
        return Logger.getLogger(DefaultFaceletConfigResourceProviderFactory.class.getName());
    }

    @Override
    public FaceletConfigResourceProvider createFaceletConfigResourceProvider(ExternalContext externalContext) {
        FaceletConfigResourceProvider instance = null;
        try {
            instance = this.resolveFaceletConfigResourceProviderFromService(externalContext);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            this.getLogger().log(Level.SEVERE, "", e);
        }
        return instance;
    }

    private FaceletConfigResourceProvider resolveFaceletConfigResourceProviderFromService(ExternalContext externalContext) throws ClassNotFoundException, NoClassDefFoundError, InstantiationException, IllegalAccessException, InvocationTargetException {
        List<String> classList = (List<String>)externalContext.getApplicationMap().get(FACELET_CONFIG_PROVIDER_LIST);
        if (classList == null) {
            classList = ServiceProviderFinderFactory.getServiceProviderFinder(externalContext).getServiceProviderList(FACELET_CONFIG_PROVIDER);
            externalContext.getApplicationMap().put(FACELET_CONFIG_PROVIDER_LIST, classList);
        }
        return ClassUtils.buildApplicationObject(FaceletConfigResourceProvider.class, classList, new DefaultFaceletConfigResourceProvider());
    }
}

