#include <Xclasses/Xclasses.h>
#include <stdio.h>
#include <string.h>


XCprogram myprg("id_example",
                XCP_Author,"Jrgen Schmitz",
                XCP_Copyright,"only copied with Xclasses, free to modify for own use",
                XCP_Version,"1.0",
                XCP_EMail,"schmitzj@fsai.fh-trier.de",
                XCP_WWW,"http://fsai.fh-trier.de/~schmitzj/computer/Xclasses",
                XCP_OwnHTML,"This is an example of Xclasses using ID's for gadget"
                            "identification.<p>"
                            "<ul><li>each gadget has an ID (an integer value)"
                            "<li>the handle function returns a value for window close and gadget selection"
                            "<li>if gadget we look for the ID"
                            "<li>finally a switch/case to handle the selection"
                            "</ul>",
                XCP_Desc,"Example program for Xclasses",
                XCP_Done);


appwindow mywin;

group maingroup;
bordergroup inputgroup;
group buttongroup;
input inp_name;
fbutton but_start,but_quit;
textbox txt_output;
ruler rl_1;
menu mymenu;

#define ID_MENU     1
#define ID_START    2
#define ID_QUIT     3

void finger(void)
{
    char uname[9];
    FILE *command;
    char com_str[30]="finger ";
    char buffer[200],*c;
    int pos;

    inp_name.Input(uname);

    strcat(com_str,uname);
    if (command=popen(com_str,"r"))
    {
        txt_output.AppendText("\n\n");
        while (!feof(command))
        {
            if (fgets(buffer,sizeof(buffer),command))
            {
                c=buffer;
                pos=0;
                while (*c)
                {
                    if (*c=='\t')
                    {
                        *c=' ';
                    }
                    if (*c=='\n')
                        pos=0;
                    else
                        pos++;
                    c++;
                }
                txt_output.AppendText(buffer);
                mywin.Update();
            }
        }
        pclose(command);
    }
}
int handleMenu(void)
{
    int r=0;
    switch(mymenu.Selection())
    {
        case 0x01000001:
            r=1;
            break;
    }
    return r;
}
int main(int argc, char *argv[])
{
    mywin.InitSize(10,10,30);
    if (!mywin.Init(argc,argv))
    {
        printf("Error:\nCan't open display %s\n\n",mywin.DisplayName());
        exit(1);
    }

    mymenu.AddMenu("Program");
    mymenu.Add("Quit","q",1);
    mymenu.ID(ID_MENU);
    
    maingroup.Vert();
    maingroup.YDistance(4);
    maingroup.Add(inputgroup);
     inputgroup.Title("Finger");
     inputgroup.Horiz();
     inputgroup.HelpText("Username to finger\nor empty for all logged in useds");
     inputgroup.Add(inp_name);
      inp_name.MaxChars(8);
      inp_name.Text("Username");
      inp_name.AlwaysMode();
      inp_name.ID(ID_START);
     inputgroup.Add(but_start);
      but_start.Text("Finger");
      but_start.Weight(50);
      but_start.ID(ID_START);
    maingroup.Add(txt_output);
     txt_output.ReadOnly();
     txt_output.AlwaysShowLast();
    maingroup.Add(rl_1);
    maingroup.Add(but_quit);
     but_quit.Text("Quit");
     but_quit.ID(ID_QUIT);

    mywin.SetGroup(maingroup);
    mywin.SetMenu(mymenu);

    mywin.Create();
    int done=0,r;
    while (!done)
    {
        r=appwindow::NextEvent();
        if (r==EV_WINDOWCLOSE)
        {
            if (mywin.CloseMe)
                done=1;
        }
        else if (r==EV_GADGET)
        {
            switch(appwindow::ID())
            {
                case ID_MENU:
                    done=handleMenu();
                    break;
                case ID_START:
                    finger();
                    break;
                case ID_QUIT:
                    done=1;
                    break;
            }
        }
    }
    mywin.Close();
    return 0;
}

