#ifndef MAILLIST_H
#define MAILLIST_H

#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#define MAIL "/usr/lib/sendmail -oi -oeq"
#define VERSION "0.8a"

#define CFGFILE		"/etc/maillist.cf"
#define DESCNAME	"description"
#define READERS		"subscribed"
#define LOCKFILE	"/tmp/maillist_lock"

#define MAXLISTS	10

char lists[10][30]={"","","","","","","","","",""};
char listdir[60]="",helpdir[60]="",cmdname[30]="";
char logfile[100]="/tmp/maillist.log";
char mailaddress[60]="";
int lists_c=0;

configopts cfg_o[]={
	{"T30-MC:list",(char*)&lists_c},
	{"T30-M:list",lists[0]},
	{"T30-M:list",lists[1]},
	{"T30-M:list",lists[2]},
	{"T30-M:list",lists[3]},
	{"T30-M:list",lists[4]},
	{"T30-M:list",lists[5]},
	{"T30-M:list",lists[6]},
	{"T30-M:list",lists[7]},
	{"T30-M:list",lists[8]},
	{"T30-M:list",lists[9]},
	{"S60:listsdir",listdir},
	{"S60:helpdir",helpdir},
	{"S30:cmdname",cmdname},
	{"S60:mailaddress",mailaddress},
	{"T100:logfile",logfile},
	{NULL,NULL}};

int _lock=0;
char *mklockname(int nr)
{
	static char buf[100];
	sprintf(buf,"%s_%d",LOCKFILE,nr);
	return buf;
}
int lock(int nr)
{
	if ((_lock=open(mklockname(nr),O_CREAT|O_EXCL))>0)
	{
		return 1;
	}
	return 0;
}
int lockwait(int nr)
{
	int c=0;
	do
	{
		if ((_lock=open(mklockname(nr),O_CREAT|O_EXCL))>0)
		{
			return 1;
		}
		sleep(1);
		c++;
	}
	while (c<120);
	unlink(mklockname(nr));
	return 0;
}
int checklock(int nr)
{
	int l;
	if ((l=open(mklockname(nr),O_RDONLY))>0)
	{
		close(l);
		return 1;
	}
	return 0;
}
void unlock(int nr)
{
	if (_lock>0)
	{
		close(_lock);
		unlink(mklockname(nr));
		_lock=0;
	}
}

#endif
