#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdlib.h>

#include <Xclasses/gadget.h>
#include <Xclasses/button.h>
#include <Xclasses/Xcolors.h>
#include <Xclasses/mxbutton.h>
#include <Xclasses/selbutton.h>
#include <Xclasses/indicator.h>

char *hello="Hello world.";
char *hi="Hi";

void main (int argc, char *argv[])
{
    Window mywindow;
    Xcolors xd;
    GC mygc;

    if (!xd.Init(argc,argv))
    {
        printf("Error:\nCan't open display\n\n");
        exit(1);
    }

    XEvent myevent;
    XSizeHints myhint;
    unsigned long myforeground, mybackground,red;
    int v=0,vp=1;
    char text[20];
    int done;
    char dot[]={6,3};
    char *btxts[]={"Knopf 1","Knopf 2","Knopf 3","Knopf 4",NULL};

    gadget g1;
    button g2,g3,g4,g5;
    mxbutton g6;
    selbutton g7;
    indicator g8;

    mybackground=WhitePixel(xd.display(),xd.screen());
    myforeground=BlackPixel(xd.display(),xd.screen());
    red=xd.AllocColor("red");

    myhint.x=200; myhint.y=300;
    myhint.width=350; myhint.height=250;
    myhint.flags=PPosition|PSize;

    mywindow=XCreateSimpleWindow(xd.display(),DefaultRootWindow(xd.display()),
                                 myhint.x, myhint.y, myhint.width, myhint.height,
                                 5, myforeground, xd.col_background() ); // mybackground);

    XSetStandardProperties(xd.display(),mywindow,hello,hello,None, argv,argc, &myhint);

    mygc=XCreateGC(xd.display(),mywindow,0,0);
    XSetBackground(xd.display(),mygc,mybackground);
    XSetForeground(xd.display(),mygc,myforeground);

    XSelectInput(xd.display(),mywindow,ButtonPressMask|KeyPressMask|ExposureMask);
    XMapRaised(xd.display(),mywindow);

    g1.Dimensions(mywindow,300,50,40,20);
    g1.ID(1);
    g1.Create();
    g2.Dimensions(mywindow,10,60,90,24);
    g2.ID(2);
    g2.Font("-*-helvetica-*-*-*-*-15-*-*-*-*-*-*-*");
    g2.Text("Ende");    
    g2.Create();
    g3.Dimensions(mywindow,10,85,90,24);
    g3.ID(3);
    g3.Font("-*-lucida-medium-r-*-*-12-*-*-*-*-*-*-*");    
    g3.Text("Unlock");    
    g3.Create();
    g4.Dimensions(mywindow,10,110,90,24);
    g4.ID(4);
    g4.Font("-*-lucida-*-r-*-*-15-*-*-*-*-*-*-*");        
    g4.Text("Lock");    
    g4.Create();
    g5.Dimensions(mywindow,10,160,90,24);
    g5.ID(5);
    g5.Font("-*-lucida-*-r-*-*-15-*-*-*-*-*-*-*");        
    g5.Text("grer machen");    
    g5.Create();

    g6.Dimensions(mywindow,200,60,90,24*5);
    g6.ID(6);
    g6.Font("-*-lucida-*-r-*-*-15-*-*-*-*-*-*-*");        
    g6.Items(btxts);    
    g6.Create();

    g7.Dimensions(mywindow,10,135,90,24);
    g7.ID(7);
    g7.Font("-*-lucida-*-r-*-*-15-*-*-*-*-*-*-*");        
    g7.Text("Switch");    
    g7.Create();

    g8.Dimensions(mywindow,1,1,348,45);
    g8.Font("-*-lucida-*-r-*-*-15-*-*-*-*-*-*-*");        
    g8.Title("Fortschritt");
    g8.MaxValue(200);
    g8.Create();


    done=0;
    while(!done)
    {
        XNextEvent(xd.display(),&myevent);
        sprintf(text,"Wert: %d,%02d",v/100,v-(v/100)*100);
        g8.Value(v,text); v+=vp; 
        if (v>200) v=200;
        if (v<0) v=0;
        switch (g1.HandleEvent(&myevent))
        {
            case 0:

            switch (myevent.type)
            {
                case Expose:
                    if (myevent.xexpose.count==0)
                    {
                        int i;
						XSetForeground(myevent.xexpose.display,mygc,myforeground);                        
//						XSetBackground(myevent.xexpose.display,mygc,mybackground);						
                        XDrawString(myevent.xexpose.display,myevent.xexpose.window,
                                         mygc,50,58,hello, strlen(hello));
                        XSetDashes(myevent.xexpose.display,mygc,0,dot,2);
                        XSetLineAttributes(myevent.xexpose.display,mygc,
                                           2,LineOnOffDash,CapButt,JoinRound);
						XSetForeground(myevent.xexpose.display,mygc,red);
                        for(i=0;i<360;i+=36)
                        XDrawLine(myevent.xexpose.display,myevent.xexpose.window,mygc,
                                  150,100,(int)(150+40*cos(i*M_PI/180.0)),(int)(100+40*sin(i*M_PI/180.0)));
                    }
                    break;
                case MappingNotify:
                    XRefreshKeyboardMapping((XMappingEvent*)&myevent);
                    break;
                case ButtonPress:
//                    XDrawImageString(myevent.xexpose.display,myevent.xexpose.window,
//                                     mygc,myevent.xbutton.x,myevent.xbutton.y,hi, strlen(hi));
                    break;
            }
            break;
            case 1:
                g1.ResizeD(1,1);
                break;
            case 2:
                done=1;
                break;
	  	  	case 3:
				g4.Unlock();
				g5.Lock();
				g6.Unlock();
				g7.Unlock();				
				g8.Value(0); v=0;
				break;
	    	case 4:
				g4.Lock();
				g5.Unlock();
				g6.Lock();
				g7.Lock();
				break;
			case 5:
				g5.ResizeD(1,1);
				break;
			case 6:
				vp=(g6.Selected()+1)*(vp/abs(vp));
				break;
			case 7:
				if (g7.State()==PRESSED) vp=-1; else vp=1;
				g6.Selected(0);
				break;
        }
    }

    XFreeGC(xd.display(),mygc);
    XDestroyWindow(xd.display(),mywindow);
    exit(0);
}

