#include <unistd.h>

#include <Xclasses/Xclasses.h>

appwindow w;

group mg;
bordergroup sg1,sg2,sg3,sg4;
button ende;
selbutton lk1,lk2,lk3,lk4,lk5;
text tx1,tx2,tx3,tx4,tx5;
listview *lv1,*lv2,*lv3,*lv4;
dirview *lv5;
ruler rl1,rl2;

char zw[50];

#define GGFONT	FONT_GADGET
#define GPFONT 	FONT_GROUP
#define FIXGGFONT	FONT_FIXED

int main(int argc,char *argv[])
{
	int r,pende=0;

	w.InitSize(0,0,300,300);	
	if (!w.Init(argc,argv))
	{
		printf("Error:\nCan't open display\n\n");
		exit(1);
	}

	w.Title("Mein Fenster");
	w.IconTitle("Mein Icon");

	lv1=new listview;
	lv2=new listview;
	lv3=new listview;
	lv4=new listview;
	lv5=new dirview;
	
	mg.Background(0xa0a0,0xa0a0,0xc0c0);
	mg.Vert();
	mg.Font(GPFONT);

	mg.Add(sg1);
//	 sg1.Weight(4);
	 sg1.Weight(200);
	 sg1.Font(GPFONT);
	 sg1.Horiz();
	 sg1.Title("Listview");
	 sg1.Add(lv1);
	  lv1->ShowSelected();
	  lv1->Font(GGFONT);
	  for(int i=1;i<40;i++)
	  {
	  		sprintf(zw,"Text %2d",i);
		  	lv1->AddAtEnd(zw);
		  	if (i%5==0) lv1->LockItem(i);
	  }
	  lv1->HelpText("Listview 1:\nShowSelected");
	  lv1->ID(100);
	 sg1.Add(lv2);
	  lv2->Font(GGFONT);
	  for(int i=1;i<30;i++)
	  {
	  		sprintf(zw,"2. Text %2d",i);
//		  	lv2->AddAtEnd(zw);
//		  	if (i%4==0) lv2->LockItem(i);
	  }
	  lv2->HelpText("Listview 2:\nnot ShowSelected");
	  lv2->ID(101);
	 sg1.Add(lv3);
	  lv3->Font(GGFONT);
	  lv3->ReadOnly();
	  for(int i=1;i<25;i++)
	  {
	  		sprintf(zw,"R/O Text %2d",i);
//		  	lv3->AddAtEnd(zw);
	  }
	  lv3->HelpText("Listview 3:\nnot ReadOnly");
	  lv3->ID(102);
	 sg1.Add(rl1);
	  rl1.Vert();
	  rl1.Space(10);
	 sg1.Add(lv4);
	  lv4->Font(GGFONT);
	  lv4->MultiSelect();
	  lv4->ShowSelected();
	  lv4->ID(103);
	  lv4->HelpText("Listview 4:\nMultiselect");
	  for(int i=1;i<25;i++)
	  {
	  		sprintf(zw,"MS Text %2d",i);
		  	lv4->AddAtEnd(zw);
		  	if (i%5==0) lv4->LockItem(i);
	  }
	 sg1.Add(lv5);
	  lv5->Font(FIXGGFONT);
//	  lv5->MultiSelect();
//	  lv5->DirectMulti();
//	  lv5->ShowSelected();
	  lv5->ID(104);
	  lv5->HelpText("Listview 5:\nDirectory Listview");
//	  for(int i=1;i<28;i++)
//	  {
//	  		sprintf(zw,"DMS Text %2d",i);
//		  	lv5->AddAtEnd(zw);
//		  	if (i%6==0) lv5->LockItem(i);
//	  }

	mg.Add(sg2);
	 sg2.Font(GPFONT);
	 sg2.Horiz();
	 sg2.Title("Ergebnisse");
	  sg2.Add(tx1);
	   tx1.Font(GGFONT);
	   tx1.Center();
	   tx1.Text("Listview 1:\n \n ");
	  sg2.Add(tx2);
	   tx2.Font(GGFONT);
	   tx2.Center();
	   tx2.Text("Listview 2:\n \n ");
	  sg2.Add(tx3);
	   tx3.Font(GGFONT);
	   tx3.Center();
	   tx3.Text("Listview 3:\n---\n");
	  sg2.Add(rl2);
	   rl2.Vert();
	   rl2.Space(10);
	  sg2.Add(tx4);
	   tx4.Font(GGFONT);
	   tx4.Center();
	   tx4.Text("Listview 4:\n\n ");
	  sg2.Add(tx5);
	   tx5.Font(GGFONT);
	   tx5.Center();
	   tx5.Text("Listview 5:\n\n ");

	mg.Add(sg4);
	 sg4.Weight(25);
	 sg4.Font(GPFONT);
	 sg4.Horiz();
	 sg4.Title("Sperre");
	 sg4.Add(lk1);
	  lk1.Text("Listview 1");
	  lk1.Font(GGFONT);
	  lk1.ID(11);
	 sg4.Add(lk2);
	  lk2.Text("Listview 2");
	  lk2.Font(GGFONT);
	  lk2.ID(12);
	 sg4.Add(lk3);
	  lk3.Text("Listview 3");
	  lk3.Font(GGFONT);
	  lk3.ID(13);
	 sg4.Add(lk4);
	  lk4.Text("Listview 4");
	  lk4.Font(GGFONT);
	  lk4.ID(14);
	 sg4.Add(lk5);
	  lk5.Text("Listview 5");
	  lk5.Font(GGFONT);
	  lk5.ID(15);

	mg.Add(sg3);
	 sg3.Weight(25);
	 sg3.Font(GPFONT);
	 sg3.Vert();
	 sg3.Title("Buttons");
	 sg3.Add(ende);
	  ende.Text("Programm beenden");
	  ende.Font(GGFONT);
	  ende.ID(1);
	  ende.HelpText("Beendet\ndas Programm.");

	w.SetGroup(mg);
	w.Create(); 
	do
	{
		r=w.NextEvent();
		if (r==EV_WINDOWCLOSE)
		{
			pende=1;
		}
		else if (EV_GADGET)
		{
			switch (w.ID())
			{
				case 1:
					pende=1;
					break;
				case 11:
					if (lk1.State()==PRESSED) lv1->Lock(); else lv1->Unlock();
					break;
				case 12:
					if (lk2.State()==PRESSED) lv2->Lock(); else lv2->Unlock();
					break;
				case 13:
					if (lk3.State()==PRESSED) lv3->Lock(); else lv3->Unlock();
					break;
				case 14:
					if (lk4.State()==PRESSED) lv4->Lock(); else lv4->Unlock();
					break;
				case 15:
					if (lk5.State()==PRESSED) lv5->Lock(); else lv5->Unlock();
					break;
	
				case 100:
					sprintf(zw,"Listview 1:\nAuswahl %d\n%s",lv1->Selected(),mg.DoubleClick()?"Doppel Klick":"");
					tx1.Text(zw);
					if (w.DoubleClick())
					{
						lv2->RemoveAll();
						for(int i=0;i<lv1->Selected();i++)
						{
					  		sprintf(zw,"Text %2d",i+1);
						  	lv2->AddAtEnd(zw);
						}
					}
					break;
				case 101:
					sprintf(zw,"Listview 2:\nAuswahl %d\n%s",lv2->Selected(),mg.DoubleClick()?"Doppel Klick":"");
					tx2.Text(zw);
					lv3->RemoveAll();
					for(int i=0;i<lv2->Selected();i++)
					{
			  			sprintf(zw,"R/O Text %2d",i+1);
					  	lv3->AddAtEnd(zw);
					}
					break;
				case 102:
					sprintf(zw,"Listview 3:\nAuswahl %d - unmglich!",lv3->Selected());
					tx3.Text(zw);
					break;
				case 103:
					sprintf(zw,"Listview 4:\nAuswahl %d\n%s",lv4->Selected(),mg.DoubleClick()?"Doppel Klick":"");
					tx4.Text(zw);
					break;
				case 104:
					sprintf(zw,"Listview 5:\nAuswahl %d\n%s",lv5->Selected(),mg.DoubleClick()?"Doppel Klick":"");
					tx5.Text(zw);
					break;
			}
		}
	}
	while (!pende);

	w.Close();
}
