#ifndef INCL_DIRVIEW_H
#define INCL_DIRVIEW_H

// *-----------------------------------------------------------------------
// * Xclasses class header file
// * 
// * class name: dirview
// * author    : Jrgen Schmitz
// * version   : 1.0
// *-----------------------------------------------------------------------

#include <Xclasses/types.h>
#include <Xclasses/gadget.h>
#include <Xclasses/listview.h>
#include <Xclasses/input.h>

class dirview : public multilistview
{
	friend class pdirview;

	class pdirview *p;

public:
    virtual int  GActivate(XEvent *event,int why);
    virtual int  GSelected(XEvent *event,int why,int wasabove);

public:
    dirview();
    dirview(char *dir);
    virtual ~dirview();

    virtual int Create(void);
    virtual void Free(void);

	void ApplyInput(input *);
	void ApplyInput(input &);

	void SetDir(char *);
	void RereadDir(void);
	void GetDir(char *,int size);
	void GetFile(char *,int size);
	void SetPattern(char *);
	void ShowPeriod(void);
	void NoPeriod(void);
	void DirsFirst(void);
	void DirsNormal(void);
	void DirsOnly(void);
	void FilesOnly(void);
	void DirsFiles(void);

	int IsSelectedMarked(void);
	int FindNextMarked(int,char *,int size);
};

#endif
