
package Paws::Athena::ListWorkGroupsOutput;
  use Moose;
  has NextToken => (is => 'ro', isa => 'Str');
  has WorkGroups => (is => 'ro', isa => 'ArrayRef[Paws::Athena::WorkGroupSummary]');

  has _request_id => (is => 'ro', isa => 'Str');

### main pod documentation begin ###

=head1 NAME

Paws::Athena::ListWorkGroupsOutput

=head1 ATTRIBUTES


=head2 NextToken => Str

A token generated by the Athena service that specifies where to
continue pagination if a previous request was truncated. To obtain the
next set of pages, pass in the C<NextToken> from the response object of
the previous page call.


=head2 WorkGroups => ArrayRef[L<Paws::Athena::WorkGroupSummary>]

A list of WorkGroupSummary objects that include the names,
descriptions, creation times, and states for each workgroup.


=head2 _request_id => Str


=cut

1;