/* -*-pgsql-c-*- */
/*
 * $Header: /home/t-ishii/repository/pgpool/pool_auth.c,v 1.1.1.1 2003/06/24 05:23:55 t-ishii Exp $
 *
 * pgpool: a language independent connection pool server for PostgreSQL 
 * written by Tatsuo Ishii
 *
 * Copyright (c) 2003	Tatsuo Ishii
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of the
 * author not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission. The author makes no representations about the
 * suitability of this software for any purpose.  It is provided "as
 * is" without express or implied warranty.
 *
 * pool_auth.c: authenticaton stuff
 *
*/

#include "pool.h"

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif
#ifdef HAVE_PARAM_H
#include <param.h>
#endif
#include <errno.h>
#include <string.h>

/*
* do authentication against backend. if success return 0 otherwise non 0.
*/
POOL_STATUS pool_do_auth(POOL_CONNECTION *frontend,
						 POOL_CONNECTION_POOL *cp)
{
	POOL_CONNECTION *backend = cp->con;
	int status;
	char kind;
	int pid;
	int key;

	status = pool_read(backend, &kind, 1);
	if (status < 0)
	{
		pool_error("pool_do_auth: error while reading \"R\"", strerror(errno));
		return -1;
	}
	/* Error response? */
	else if (kind == 'E')
	{
		ErrorResponse(frontend, backend);
		return -1;
	}
	if (kind != 'R')
	{
		pool_error("pool_do_auth: expect \"R\" got %c", kind);
		return -1;
	}

	status = pool_read(backend, &pid, sizeof(pid));

	if (status < 0 || pid != 0)
	{
		pool_error("pool_do_auth: backend does not return Authenticaton Ok");
		return -1;
	}

	/*
	 * Authentication OK. Now read pid and secret key from the
	 * backend
	 */
	kind = 'W';
	status = pool_read(backend, &kind, 1);
	if (status < 0)
	{
		pool_error("pool_do_auth: error while reading \"W\"");
		return -1;
	}

	/* Error response? */
	if (kind == 'E')
	{
		ErrorResponse(frontend, backend);
		return -1;
	}
	else if (kind != 'K')
	{
		pool_error("pool_do_auth: expect \"K\" got %c", kind);
		return -1;
	}

	/*
	 * OK, read pid and secret key
	 */
	/* pid */
	pool_read(backend, &pid, sizeof(pid));
	cp->pid = pid;

	/* key */
	pool_read(backend, &key, sizeof(key));
	cp->key = key;

	return (pool_send_auth_ok(frontend, pid, key));
}


/*
* send authentication ok to frontend. if success return 0 otherwise non 0.
*/
POOL_STATUS pool_send_auth_ok(POOL_CONNECTION *frontend, int pid, int key)
{
	char kind;
	char buff[128];
	int len;

	/* return "Authentication OK" to the frontend */
	kind = 'R';
	pool_write(frontend, &kind, 1);
	len = htonl(0);
	memcpy(buff, &len, sizeof(len));
	if (pool_write_and_flush(frontend, buff, sizeof(len)) < 0)
	{
		return -1;
	}

	/* Backend Key Data */
	kind = 'K';
	pool_write(frontend, &kind, 1);
	pool_write(frontend, &pid, sizeof(pid));
	if (pool_write_and_flush(frontend, &key, sizeof(key)) < 0)
	{
		return -1;
	}

	return 0;
}
