/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.base.BaseImplClob;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class BaseClobOutputStream
extends OutputStream {
    private static String footprint = "$Revision:   1.2  $";
    private BaseImplClob implClob;
    private Object synchronizer;
    private BaseExceptions exceptions;
    private long curPosition;
    private boolean asciiStream;

    public BaseClobOutputStream(BaseImplClob baseImplClob, long l, Object object, BaseExceptions baseExceptions) {
        this.implClob = baseImplClob;
        this.synchronizer = object;
        this.exceptions = baseExceptions;
        this.curPosition = l >= 1L ? l : 1L;
        this.asciiStream = false;
    }

    private byte[] AsciiBytesToUCS2Bytes(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length * 2];
        int n = 0;
        while (n < byArray.length) {
            byArray2[n * 2] = 0;
            byArray2[n * 2 + 1] = byArray[n];
            ++n;
        }
        return byArray2;
    }

    private byte[] UCS2BytesToAsciiBytes(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length / 2];
        int n = 0;
        while (n < byArray2.length) {
            byArray2[n] = byArray[n * 2] != 0 ? 63 : byArray[n * 2 + 1];
            ++n;
        }
        return byArray2;
    }

    public void close() throws IOException {
        this.implClob = null;
    }

    public boolean isAsciiStream() {
        return this.asciiStream;
    }

    public void setAsciiStream(boolean bl) {
        this.asciiStream = bl;
    }

    void validateClosed() throws IOException {
        if (this.implClob == null) {
            SQLException sQLException = this.exceptions.getException(6010);
            throw new IOException(sQLException.getMessage());
        }
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.validateClosed();
            if (n2 == 0) {
                Object var5_5 = null;
                return;
            }
            if (n < 0 || n + n2 > byArray.length) {
                String[] stringArray = new String[]{new String("write")};
                SQLException sQLException = this.exceptions.getException(6070, stringArray);
                throw new IOException(sQLException.getMessage());
            }
            try {
                int n3 = 0;
                switch (this.implClob.getCharacterEncoding()) {
                    case 1: {
                        if (!this.isAsciiStream()) {
                            byArray = this.UCS2BytesToAsciiBytes(byArray);
                            n2 /= 2;
                            n /= 2;
                        }
                        n3 = this.implClob.writeData(this.curPosition, byArray, n, n2);
                        break;
                    }
                    case 2: {
                        if (this.isAsciiStream()) {
                            byArray = this.AsciiBytesToUCS2Bytes(byArray);
                            n2 *= 2;
                            n *= 2;
                        }
                        if (n2 % 2 != 0) {
                            String[] stringArray = new String[]{new String("write")};
                            SQLException sQLException = this.exceptions.getException(6070, stringArray);
                            throw new IOException(sQLException.getMessage());
                        }
                        n3 = this.implClob.writeData(this.curPosition, byArray, n, n2 /= 2);
                        break;
                    }
                    default: {
                        SQLException sQLException = this.exceptions.getException(6071);
                        throw new IOException(sQLException.getMessage());
                    }
                }
                this.curPosition += (long)n2;
                if (n3 != n2) {
                    throw this.exceptions.getException(6080);
                }
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
        }
    }
}

