/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bag;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.bag.CollectionBag;
import org.apache.commons.collections4.bag.HashBag;
import org.apache.commons.collections4.bag.TreeBag;
import org.apache.commons.collections4.collection.AbstractCollectionTest;
import org.apache.commons.collections4.functors.NonePredicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CollectionBagTest<T>
extends AbstractCollectionTest<T> {
    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    protected int getIterationBehaviour() {
        return 1;
    }

    @Override
    public Collection<T> makeConfirmedCollection() {
        return new ArrayList();
    }

    @Override
    public Collection<T> makeConfirmedFullCollection() {
        Collection<T> set = this.makeConfirmedCollection();
        set.addAll(Arrays.asList(this.getFullElements()));
        return set;
    }

    @Override
    public Bag<T> makeObject() {
        return CollectionBag.collectionBag((Bag)new HashBag());
    }

    @Test
    public void testAdd_Predicate_ComparatorCustom() throws Throwable {
        TreeBag treeBagOfPredicateOfObject = new TreeBag(Comparator.comparing(Predicate::toString));
        CollectionBag collectionBagOfPredicateOfObject = new CollectionBag((Bag)treeBagOfPredicateOfObject);
        collectionBagOfPredicateOfObject.add((Object)NonePredicate.nonePredicate((Collection)collectionBagOfPredicateOfObject), 24);
    }

    @Test
    public void testAdd_Predicate_ComparatorDefault() throws Throwable {
        TreeBag treeBagOfPredicateOfObject = new TreeBag();
        CollectionBag collectionBagOfPredicateOfObject = new CollectionBag((Bag)treeBagOfPredicateOfObject);
        Assertions.assertThrows(ClassCastException.class, () -> collectionBagOfPredicateOfObject.add((Object)NonePredicate.nonePredicate((Collection)collectionBagOfPredicateOfObject), 24));
    }

    @Test
    public void testEmptyBagCompatibility() throws IOException, ClassNotFoundException {
        Bag<T> bag = this.makeObject();
        if (bag instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            Bag bag2 = (Bag)this.readExternalFormFromDisk(this.getCanonicalEmptyCollectionName(bag));
            Assertions.assertTrue((boolean)bag2.isEmpty(), (String)"Bag is empty");
            Assertions.assertEquals(bag, (Object)bag2);
        }
    }

    @Test
    public void testFullBagCompatibility() throws IOException, ClassNotFoundException {
        Bag bag = (Bag)this.makeFullCollection();
        if (bag instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            Bag bag2 = (Bag)this.readExternalFormFromDisk(this.getCanonicalFullCollectionName(bag));
            Assertions.assertEquals((int)bag.size(), (int)bag2.size(), (String)"Bag is the right size");
            Assertions.assertEquals((Object)bag, (Object)bag2);
        }
    }
}

