/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.ArrayIteratorTest;
import org.apache.commons.collections4.iterators.ArrayListIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ArrayListIteratorTest<E>
extends ArrayIteratorTest<E> {
    public ArrayListIterator<E> makeArrayListIterator(Object array) {
        return new ArrayListIterator(array);
    }

    @Override
    public ArrayListIterator<E> makeEmptyIterator() {
        return new ArrayListIterator((Object)new Object[0]);
    }

    @Override
    public ArrayListIterator<E> makeObject() {
        return new ArrayListIterator((Object)this.testArray);
    }

    @Override
    public boolean supportsRemove() {
        return false;
    }

    @Test
    public void testListIterator() {
        ArrayListIterator<E> iter = this.makeObject();
        while (iter.hasNext()) {
            iter.next();
        }
        for (int x = this.testArray.length - 1; x >= 0; --x) {
            String testValue = this.testArray[x];
            Object iterValue = iter.previous();
            Assertions.assertEquals((Object)testValue, iterValue, (String)"Iteration value is correct");
        }
        Assertions.assertFalse((boolean)iter.hasPrevious(), (String)"Iterator should now be empty");
        Assertions.assertThrows(NoSuchElementException.class, () -> iter.previous());
    }

    @Test
    public void testListIteratorSet() {
        Object[] testData = new String[]{"a", "b", "c"};
        Object[] result = new String[]{"0", "1", "2"};
        ArrayListIterator<String> iter = this.makeArrayListIterator(testData);
        int x = 0;
        while (iter.hasNext()) {
            iter.next();
            iter.set(Integer.toString(x));
            ++x;
        }
        Assertions.assertArrayEquals((Object[])testData, (Object[])result, (String)"The two arrays should have the same value, i.e. {0,1,2}");
        ArrayListIterator<String> finalIter = iter = this.makeArrayListIterator(this.testArray);
        Assertions.assertThrows(IllegalStateException.class, () -> finalIter.set("should fail"), (String)"ListIterator#set should fail if next() or previous() have not yet been called.");
    }
}

