/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections4.map.AbstractIterableMapTest;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.IdentityMap;
import org.apache.commons.collections4.map.ReferenceIdentityMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReferenceIdentityMapTest<K, V>
extends AbstractIterableMapTest<K, V> {
    private static final Integer I1A = new Integer(1);
    private static final Integer I1B = new Integer(1);
    private static final Integer I2A = new Integer(2);
    private static final Integer I2B = new Integer(2);
    WeakReference<K> keyReference;
    WeakReference<V> valueReference;

    private static void gc() {
        try {
            byte[][] tooLarge = new byte[1000000000][1000000000];
            Assertions.fail((String)"you have too much RAM");
        }
        catch (OutOfMemoryError ex) {
            System.gc();
        }
    }

    private Map<K, V> buildRefMap() {
        Object key = new Object();
        Object value = new Object();
        this.keyReference = new WeakReference<Object>(key);
        this.valueReference = new WeakReference<Object>(value);
        ReferenceIdentityMap testMap = new ReferenceIdentityMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.HARD, true);
        testMap.put(key, value);
        Assertions.assertEquals((Object)value, testMap.get(key), (String)"In map");
        Assertions.assertNotNull(this.keyReference.get(), (String)"Weak reference released early (1)");
        Assertions.assertNotNull(this.valueReference.get(), (String)"Weak reference released early (2)");
        return testMap;
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public boolean isAllowNullKey() {
        return false;
    }

    @Override
    public boolean isAllowNullValueGet() {
        return true;
    }

    @Override
    public boolean isAllowNullValuePut() {
        return false;
    }

    @Override
    public Map<K, V> makeConfirmedMap() {
        return new IdentityMap();
    }

    @Override
    public ReferenceIdentityMap<K, V> makeObject() {
        return new ReferenceIdentityMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.WEAK);
    }

    @Test
    public void testBasics() {
        ReferenceIdentityMap map = new ReferenceIdentityMap(AbstractReferenceMap.ReferenceStrength.HARD, AbstractReferenceMap.ReferenceStrength.HARD);
        Assertions.assertEquals((int)0, (int)map.size());
        map.put((Object)I1A, (Object)I2A);
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertSame((Object)I2A, (Object)map.get((Object)I1A));
        Assertions.assertSame(null, (Object)map.get((Object)I1B));
        Assertions.assertTrue((boolean)map.containsKey((Object)I1A));
        Assertions.assertFalse((boolean)map.containsKey((Object)I1B));
        Assertions.assertTrue((boolean)map.containsValue((Object)I2A));
        Assertions.assertFalse((boolean)map.containsValue((Object)I2B));
        map.put((Object)I1A, (Object)I2B);
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertSame((Object)I2B, (Object)map.get((Object)I1A));
        Assertions.assertSame(null, (Object)map.get((Object)I1B));
        Assertions.assertTrue((boolean)map.containsKey((Object)I1A));
        Assertions.assertFalse((boolean)map.containsKey((Object)I1B));
        Assertions.assertFalse((boolean)map.containsValue((Object)I2A));
        Assertions.assertTrue((boolean)map.containsValue((Object)I2B));
        map.put((Object)I1B, (Object)I2B);
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertSame((Object)I2B, (Object)map.get((Object)I1A));
        Assertions.assertSame((Object)I2B, (Object)map.get((Object)I1B));
        Assertions.assertTrue((boolean)map.containsKey((Object)I1A));
        Assertions.assertTrue((boolean)map.containsKey((Object)I1B));
        Assertions.assertFalse((boolean)map.containsValue((Object)I2A));
        Assertions.assertTrue((boolean)map.containsValue((Object)I2B));
    }

    @Test
    public void testHashEntry() {
        ReferenceIdentityMap map = new ReferenceIdentityMap(AbstractReferenceMap.ReferenceStrength.HARD, AbstractReferenceMap.ReferenceStrength.HARD);
        map.put((Object)I1A, (Object)I2A);
        map.put((Object)I1B, (Object)I2A);
        Map.Entry entry1 = (Map.Entry)map.entrySet().iterator().next();
        Iterator it = map.entrySet().iterator();
        Map.Entry entry2 = (Map.Entry)it.next();
        Map.Entry entry3 = (Map.Entry)it.next();
        Assertions.assertTrue((boolean)entry1.equals(entry2));
        Assertions.assertTrue((boolean)entry2.equals(entry1));
        Assertions.assertFalse((boolean)entry1.equals(entry3));
    }

    @Test
    public void testNullHandling() {
        this.resetFull();
        Assertions.assertNull((Object)this.getMap().get(null));
        Assertions.assertFalse((boolean)this.getMap().containsKey(null));
        Assertions.assertFalse((boolean)this.getMap().containsValue(null));
        Assertions.assertNull((Object)this.getMap().remove(null));
        Assertions.assertFalse((boolean)this.getMap().entrySet().contains(null));
        Assertions.assertFalse((boolean)this.getMap().containsKey(null));
        Assertions.assertFalse((boolean)this.getMap().containsValue(null));
        Assertions.assertThrows(NullPointerException.class, () -> this.getMap().put(null, null));
        Assertions.assertThrows(NullPointerException.class, () -> this.getMap().put(new Object(), null));
        Assertions.assertThrows(NullPointerException.class, () -> this.getMap().put(null, new Object()));
    }

    @Test
    public void testPurgeValues() throws Exception {
        Map<K, V> testMap = this.buildRefMap();
        int iterations = 0;
        int bytz = 2;
        while (true) {
            System.gc();
            if (iterations++ > 50) {
                Assertions.fail((String)"Max iterations reached before resource released.");
            }
            testMap.isEmpty();
            if (this.keyReference.get() == null && this.valueReference.get() == null) break;
            byte[] b = new byte[bytz];
            bytz *= 2;
        }
    }
}

