/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.Map;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.dataproviders.BaseControllerDataProvider;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.PipelineSwitchException;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.monitoring.mbeans.ClusterStatusMonitor;
import org.apache.helix.util.HelixUtil;
import org.apache.helix.util.RebalanceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceValidationStage
extends AbstractBaseStage {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceValidationStage.class);

    @Override
    public void process(ClusterEvent event) throws Exception {
        this._eventId = event.getEventId();
        BaseControllerDataProvider cache = (BaseControllerDataProvider)event.getAttribute(AttributeName.ControllerDataProvider.name());
        if (cache == null) {
            throw new StageException("Missing attributes in event:" + event + ". Requires DataCache");
        }
        this.processManagementMode(event, cache);
        Map resourceMap = (Map)event.getAttribute(AttributeName.RESOURCES.name());
        if (resourceMap == null) {
            throw new StageException("Resources must be computed prior to validation!");
        }
        Map<String, IdealState> idealStateMap = cache.getIdealStates();
        Map<String, Map<String, String>> idealStateRuleMap = cache.getIdealStateRules();
        for (String resourceName : idealStateMap.keySet()) {
            String stateModelDefRef;
            StateModelDefinition stateModelDef;
            IdealState idealState = idealStateMap.get(resourceName);
            if (!idealStateRuleMap.isEmpty()) {
                boolean hasMatchingRule = false;
                for (String ruleName : idealStateRuleMap.keySet()) {
                    Map<String, String> rule = idealStateRuleMap.get(ruleName);
                    boolean matches = this.idealStateMatchesRule(idealState, rule);
                    boolean bl = hasMatchingRule = hasMatchingRule || matches;
                    if (!matches) continue;
                    break;
                }
                if (!hasMatchingRule) {
                    LogUtil.logWarn(LOG, this._eventId, "Resource " + resourceName + " does not have a valid ideal state!");
                    resourceMap.remove(resourceName);
                }
            }
            if ((stateModelDef = cache.getStateModelDef(stateModelDefRef = idealState.getStateModelDefRef())) != null) continue;
            LogUtil.logWarn(LOG, this._eventId, "Resource " + resourceName + " uses state model " + stateModelDefRef + ", but it is not on the cluster!");
            resourceMap.remove(resourceName);
        }
    }

    private void processManagementMode(ClusterEvent event, BaseControllerDataProvider cache) throws StageException {
        ClusterStatusMonitor monitor = (ClusterStatusMonitor)event.getAttribute(AttributeName.clusterStatusMonitor.name());
        if (monitor != null) {
            monitor.setMaintenance(cache.isMaintenanceModeEnabled());
        }
        if (HelixUtil.inManagementMode(cache.getPauseSignal(), cache.getLiveInstances(), cache.getEnabledLiveInstances(), cache.getAllInstancesMessages())) {
            LogUtil.logInfo(LOG, this._eventId, "Enabling management mode pipeline for cluster " + event.getClusterName());
            RebalanceUtil.enableManagementMode(event.getClusterName(), true);
            throw new PipelineSwitchException("Pipeline should not be run because cluster " + event.getClusterName() + " is in management mode");
        }
    }

    private boolean idealStateMatchesRule(IdealState idealState, Map<String, String> rule) {
        Map<String, String> simpleFields = idealState.getRecord().getSimpleFields();
        for (String key : rule.keySet()) {
            String value = rule.get(key);
            if (simpleFields.containsKey(key) && value.equals(simpleFields.get(key))) continue;
            return false;
        }
        return true;
    }
}

