/*
 * Decompiled with CFR 0.152.
 */
package cisco.infra.dma.maven.mojo;

import cisco.infra.dma.repo.BadDmaName;
import cisco.infra.dma.repo.Namespaces;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public abstract class AbstractDmaMojo
extends AbstractMojo {
    static final String DMA_COMMIT_NOTIFICATIONS = "dma:commit-notifications";
    static final String DEV_REPO = "http://dft-releng-02.cisco.com/svn/repo/";
    static final String REPO = "http://dft-releng-03.cisco.com/svn/cisco.repo";
    public MavenProject project;
    protected boolean underTest = false;
    protected boolean debug = false;

    public static void removeTestRepoSpace() {
        System.out.println("Okay");
    }

    protected void turnOffProxyHosts() {
        System.setProperty("socksProxyHost", "");
        System.setProperty("socksProxyPort", "");
    }

    protected SVNRepository connectToProjectRoot() throws SVNException, BadDmaName {
        this.getLog().info((CharSequence)"Connecting to the repo...");
        this.getLog().info((CharSequence)("UnderTest Value :" + this.underTest));
        DAVRepositoryFactory.setup();
        SVNURL url = SVNURL.parseURIEncoded((String)(this.repoUrl() + "/" + this.getSvnProjectSpaceRootPath()));
        SVNRepository repo = SVNRepositoryFactory.create((SVNURL)url);
        this.getLog().info((CharSequence)("Using URL " + url.toDecodedString()));
        String userName = "robevans";
        String userPassword = "robevans";
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)userName, (String)userPassword);
        repo.setAuthenticationManager(authManager);
        return repo;
    }

    protected SVNRepository connectToFixedCategorySpace() throws SVNException {
        this.getLog().info((CharSequence)"Connecting to the repo...");
        this.getLog().info((CharSequence)("UnderTest Value :" + this.underTest));
        DAVRepositoryFactory.setup();
        SVNURL url = SVNURL.parseURIEncoded((String)(this.repoUrl() + "/" + this.project.getGroupId()));
        SVNRepository repo = SVNRepositoryFactory.create((SVNURL)url);
        this.getLog().info((CharSequence)("Using URL " + url.toDecodedString()));
        String userName = "robevans";
        String userPassword = "robevans";
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)userName, (String)userPassword);
        repo.setAuthenticationManager(authManager);
        return repo;
    }

    public boolean isUnderTest() {
        return this.underTest;
    }

    public void setUnderTest(boolean underTest) {
        this.underTest = underTest;
    }

    protected String repoUrl() throws SVNException {
        if (this.underTest) {
            return DEV_REPO;
        }
        return REPO;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    private String getSvnProjectSpaceRootPath() throws BadDmaName {
        return Namespaces.getSvnProjectSpaceRootPath(this.project);
    }

    public String getSvnProjectSpacePath() throws BadDmaName {
        return Namespaces.getDmaRepoPathForPom(this.project);
    }
}

