/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.testng.ClassMethodMap;
import org.testng.IClass;
import org.testng.IMethodSelector;
import org.testng.IResultMap;
import org.testng.ISuite;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestClass;
import org.testng.internal.ClassHelper;
import org.testng.internal.ConfigurationGroupMethods;
import org.testng.internal.Constants;
import org.testng.internal.IConfigurationListener;
import org.testng.internal.IInvoker;
import org.testng.internal.IMethodWorker;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.InvokedMethod;
import org.testng.internal.Invoker;
import org.testng.internal.MethodHelper;
import org.testng.internal.MethodInstance;
import org.testng.internal.ResultMap;
import org.testng.internal.RunInfo;
import org.testng.internal.TestMethodWorker;
import org.testng.internal.TestNGClassFinder;
import org.testng.internal.TestNGMethod;
import org.testng.internal.TestNGMethodFinder;
import org.testng.internal.Utils;
import org.testng.internal.XmlMethodSelector;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.ITest;
import org.testng.internal.thread.ThreadUtil;
import org.testng.junit.IJUnitTestRunner;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRunner
implements ITestContext,
ITestResultNotifier {
    private static final long serialVersionUID = 4247820024988306670L;
    private ISuite m_suite;
    protected XmlTest m_xmlTest;
    private String m_testName;
    private boolean m_debug = false;
    private transient List<XmlClass> m_testClassesFromXml = null;
    private transient List<XmlPackage> m_packageNamesFromXml = null;
    private transient IInvoker m_invoker = null;
    private transient IAnnotationFinder m_annotationFinder = null;
    private transient List<ITestListener> m_testListeners = new ArrayList<ITestListener>();
    private transient List<IConfigurationListener> m_configurationListeners = new ArrayList<IConfigurationListener>();
    private IConfigurationListener m_confListener = new ConfigurationListener();
    private ITestNGMethod[] m_allTestMethods = new ITestNGMethod[0];
    private Date m_startDate = null;
    private Date m_endDate = null;
    private transient Map<Class, ITestClass> m_classMap = new HashMap<Class, ITestClass>();
    private String m_outputDirectory = Constants.getDefaultValueFor("testng.outputDir");
    private XmlMethodSelector m_xmlMethodSelector = new XmlMethodSelector();
    private static int m_verbose = 1;
    private ITestNGMethod[] m_beforeClassMethods = new ITestNGMethod[0];
    private ITestNGMethod[] m_afterClassMethods = new ITestNGMethod[0];
    private ITestNGMethod[] m_beforeSuiteMethods = new ITestNGMethod[0];
    private ITestNGMethod[] m_afterSuiteMethods = new ITestNGMethod[0];
    private ITestNGMethod[] m_beforeXmlTestMethods = new ITestNGMethod[0];
    private ITestNGMethod[] m_afterXmlTestMethods = new ITestNGMethod[0];
    private List<ITestNGMethod> m_excludedMethods = new ArrayList<ITestNGMethod>();
    private ConfigurationGroupMethods m_groupMethods = null;
    private Map<String, List<String>> m_metaGroups = new HashMap<String, List<String>>();
    private IResultMap m_passedTests = new ResultMap();
    private IResultMap m_failedTests = new ResultMap();
    private IResultMap m_failedButWithinSuccessPercentageTests = new ResultMap();
    private IResultMap m_skippedTests = new ResultMap();
    private RunInfo m_runInfo = new RunInfo();
    private String m_host;
    private List<InvokedMethod> m_invokedMethods = new ArrayList<InvokedMethod>();
    private IResultMap m_passedConfigurations = new ResultMap();
    private IResultMap m_skippedConfigurations = new ResultMap();
    private IResultMap m_failedConfigurations = new ResultMap();
    static /* synthetic */ Class class$org$testng$internal$annotations$ITest;

    public TestRunner(ISuite suite, XmlTest test, String outputDirectory, IAnnotationFinder finder) {
        this.init(suite, test, outputDirectory, finder);
    }

    public TestRunner(ISuite suite, XmlTest test, IAnnotationFinder finder) {
        this.init(suite, test, suite.getOutputDirectory(), finder);
    }

    public TestRunner(ISuite suite, XmlTest test) {
        this.init(suite, test, suite.getOutputDirectory(), suite.getAnnotationFinder(test.getAnnotations()));
    }

    private void init(ISuite suite, XmlTest test, String outputDirectory, IAnnotationFinder annotationFinder) {
        this.m_xmlTest = test;
        this.m_suite = suite;
        this.m_testName = test.getName();
        this.m_host = suite.getHost();
        this.m_testClassesFromXml = test.getXmlClasses();
        this.m_packageNamesFromXml = test.getXmlPackages();
        if (null != this.m_packageNamesFromXml) {
            for (XmlPackage xp : this.m_packageNamesFromXml) {
                this.m_testClassesFromXml.addAll(xp.getXmlClasses());
            }
        }
        this.m_annotationFinder = annotationFinder;
        this.m_invoker = new Invoker(this, this, this.m_suite.getSuiteState(), this.m_annotationFinder);
        this.setVerbose(test.getVerbose());
        if (suite.getParallel() != null) {
            this.log(3, new StringBuffer().append("Running the tests in '").append(test.getName()).append("' with parallel mode:").append(suite.getParallel()).toString());
        }
        this.setOutputDirectory(outputDirectory);
        this.init();
    }

    public IInvoker getInvoker() {
        return this.m_invoker;
    }

    public ITestNGMethod[] getBeforeSuiteMethods() {
        return this.m_beforeSuiteMethods;
    }

    public ITestNGMethod[] getAfterSuiteMethods() {
        return this.m_afterSuiteMethods;
    }

    public ITestNGMethod[] getBeforeTestConfigurationMethods() {
        return this.m_beforeXmlTestMethods;
    }

    public ITestNGMethod[] getAfterTestConfigurationMethods() {
        return this.m_afterXmlTestMethods;
    }

    private void init() {
        this.initMetaGroups(this.m_xmlTest);
        this.initRunInfo(this.m_xmlTest);
        if (!this.m_xmlTest.isJUnit()) {
            this.initMethods();
        }
        this.addConfigurationListener(this.m_confListener);
    }

    private void initMetaGroups(XmlTest xmlTest) {
        Map<String, List<String>> metaGroups = xmlTest.getMetaGroups();
        for (String name : metaGroups.keySet()) {
            this.addMetaGroup(name, metaGroups.get(name));
        }
    }

    private void initRunInfo(XmlTest xmlTest) {
        this.m_xmlMethodSelector.setIncludedGroups(this.createGroups(this.m_xmlTest.getIncludedGroups()));
        this.m_xmlMethodSelector.setExcludedGroups(this.createGroups(this.m_xmlTest.getExcludedGroups()));
        this.m_xmlMethodSelector.setExpression(this.m_xmlTest.getExpression());
        this.m_xmlMethodSelector.setXmlClasses(this.m_xmlTest.getXmlClasses());
        this.m_runInfo.addMethodSelector(this.m_xmlMethodSelector, 10);
        if (null != xmlTest.getMethodSelectors()) {
            for (org.testng.xml.XmlMethodSelector selector : xmlTest.getMethodSelectors()) {
                if (selector.getClassName() == null) continue;
                IMethodSelector s = ClassHelper.createSelector(selector);
                this.m_runInfo.addMethodSelector(s, selector.getPriority());
            }
        }
    }

    private void initMethods() {
        IClass[] classes;
        ArrayList<ITestNGMethod> beforeClassMethods = new ArrayList<ITestNGMethod>();
        ArrayList<ITestNGMethod> testMethods = new ArrayList<ITestNGMethod>();
        ArrayList<ITestNGMethod> afterClassMethods = new ArrayList<ITestNGMethod>();
        ArrayList<ITestNGMethod> beforeSuiteMethods = new ArrayList<ITestNGMethod>();
        ArrayList<ITestNGMethod> afterSuiteMethods = new ArrayList<ITestNGMethod>();
        ArrayList<ITestNGMethod> beforeXmlTestMethods = new ArrayList<ITestNGMethod>();
        ArrayList<ITestNGMethod> afterXmlTestMethods = new ArrayList<ITestNGMethod>();
        TestNGClassFinder testClassFinder = new TestNGClassFinder(Utils.xmlClassesToClasses(this.m_testClassesFromXml), null, this.m_xmlTest, this.m_annotationFinder);
        TestNGMethodFinder testMethodFinder = new TestNGMethodFinder(this.m_runInfo, this.m_annotationFinder);
        this.m_runInfo.setTestMethods(testMethods);
        for (IClass ic : classes = testClassFinder.findTestClasses()) {
            TestClass tc = new TestClass(ic, this.m_testName, testMethodFinder, this.m_annotationFinder, this.m_runInfo);
            this.m_classMap.put(ic.getRealClass(), tc);
        }
        Map<String, List<ITestNGMethod>> beforeGroupMethods = MethodHelper.findGroupsMethods(this.m_classMap.values(), true);
        Map<String, List<ITestNGMethod>> afterGroupMethods = MethodHelper.findGroupsMethods(this.m_classMap.values(), false);
        for (ITestClass tc : this.m_classMap.values()) {
            this.fixMethodsWithClass(tc.getBeforeClassMethods(), tc, beforeClassMethods);
            this.fixMethodsWithClass(tc.getBeforeTestMethods(), tc, null);
            this.fixMethodsWithClass(tc.getTestMethods(), tc, testMethods);
            this.fixMethodsWithClass(tc.getAfterTestMethods(), tc, null);
            this.fixMethodsWithClass(tc.getAfterClassMethods(), tc, afterClassMethods);
            this.fixMethodsWithClass(tc.getBeforeSuiteMethods(), tc, beforeSuiteMethods);
            this.fixMethodsWithClass(tc.getAfterSuiteMethods(), tc, afterSuiteMethods);
            this.fixMethodsWithClass(tc.getBeforeTestConfigurationMethods(), tc, beforeXmlTestMethods);
            this.fixMethodsWithClass(tc.getAfterTestConfigurationMethods(), tc, afterXmlTestMethods);
            this.fixMethodsWithClass(tc.getBeforeGroupsMethods(), tc, MethodHelper.uniqueMethodList(beforeGroupMethods.values()));
            this.fixMethodsWithClass(tc.getAfterGroupsMethods(), tc, MethodHelper.uniqueMethodList(afterGroupMethods.values()));
        }
        this.m_beforeSuiteMethods = MethodHelper.collectAndOrderMethods(beforeSuiteMethods, false, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods);
        this.m_beforeXmlTestMethods = MethodHelper.collectAndOrderMethods(beforeXmlTestMethods, false, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods);
        this.m_beforeClassMethods = MethodHelper.collectAndOrderMethods(beforeClassMethods, false, this.m_runInfo, this.m_annotationFinder, this.m_excludedMethods);
        this.m_allTestMethods = MethodHelper.collectAndOrderMethods(testMethods, true, this.m_runInfo, this.m_annotationFinder, this.m_excludedMethods);
        this.m_afterClassMethods = MethodHelper.collectAndOrderMethods(afterClassMethods, false, this.m_runInfo, this.m_annotationFinder, this.m_excludedMethods);
        this.m_afterXmlTestMethods = MethodHelper.collectAndOrderMethods(afterXmlTestMethods, false, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods);
        this.m_afterSuiteMethods = MethodHelper.collectAndOrderMethods(afterSuiteMethods, false, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods);
        this.m_groupMethods = new ConfigurationGroupMethods(this.m_allTestMethods, beforeGroupMethods, afterGroupMethods);
    }

    private static void ppp(String s) {
        System.out.println(new StringBuffer().append("[TestRunner] ").append(s).toString());
    }

    private void fixMethodsWithClass(ITestNGMethod[] methods, ITestClass testCls, List<ITestNGMethod> methodList) {
        for (ITestNGMethod itm : methods) {
            itm.setTestClass(testCls);
            if (methodList == null) continue;
            methodList.add(itm);
        }
    }

    public Collection<ITestClass> getIClass() {
        return this.m_classMap.values();
    }

    private IClass findIClass(IClass[] classes, Class cls) {
        for (IClass c : classes) {
            if (!c.getRealClass().equals(cls)) continue;
            return c;
        }
        return null;
    }

    public void setTestName(String name) {
        this.m_testName = name;
    }

    public void setOutputDirectory(String od) {
        if (od == null) {
            this.m_outputDirectory = null;
            return;
        }
        File file = new File(od);
        file.mkdirs();
        this.m_outputDirectory = file.getAbsolutePath();
    }

    private void addMetaGroup(String name, List<String> groupNames) {
        this.m_metaGroups.put(name, groupNames);
    }

    private void collectGroups(String[] groups, List<String> unfinishedGroups, Map<String, String> result) {
        for (String gn : groups) {
            List<String> subGroups = this.m_metaGroups.get(gn);
            if (null == subGroups) continue;
            for (String sg : subGroups) {
                if (null != result.get(sg)) continue;
                result.put(sg, sg);
                unfinishedGroups.add(sg);
            }
        }
    }

    private Map<String, String> createGroups(List<String> groups) {
        return this.createGroups(groups.toArray(new String[groups.size()]));
    }

    private Map<String, String> createGroups(String[] groups) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String group : groups) {
            result.put(group, group);
        }
        ArrayList<String> unfinishedGroups = new ArrayList<String>();
        if (this.m_metaGroups.size() > 0) {
            this.collectGroups(groups, unfinishedGroups, result);
            while (unfinishedGroups.size() > 0) {
                String[] uGroups = unfinishedGroups.toArray(new String[unfinishedGroups.size()]);
                unfinishedGroups = new ArrayList();
                this.collectGroups(uGroups, unfinishedGroups, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.beforeRun();
        try {
            XmlTest test = this.getTest();
            if (test.isJUnit()) {
                this.privateRunJUnit(test);
            } else {
                this.privateRun(test);
            }
        }
        finally {
            this.afterRun();
        }
    }

    private void beforeRun() {
        this.m_startDate = new Date(System.currentTimeMillis());
        this.logStart();
        this.fireEvent(true);
        ITestNGMethod[] testConfigurationMethods = this.getBeforeTestConfigurationMethods();
        if (null != testConfigurationMethods && testConfigurationMethods.length > 0) {
            this.m_invoker.invokeConfigurations(null, testConfigurationMethods, this.m_xmlTest.getSuite(), this.m_xmlTest.getParameters(), null);
        }
    }

    private void privateRunJUnit(XmlTest xmlTest) {
        final Class[] classes = Utils.xmlClassesToClasses(this.m_testClassesFromXml);
        final ArrayList runMethods = new ArrayList();
        ArrayList<1> workers = new ArrayList<1>();
        workers.add(new IMethodWorker(){

            public long getMaxTimeOut() {
                return 0L;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Class[] arr$ = classes;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Class tc = arr$[i$];
                    IJUnitTestRunner tr = ClassHelper.createTestRunner(TestRunner.this);
                    try {
                        tr.run(tc);
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        continue;
                    }
                    finally {
                        runMethods.addAll(tr.getTestMethods());
                    }
                }
            }
        });
        this.runWorkers(workers, "");
        this.m_allTestMethods = runMethods.toArray(new ITestNGMethod[runMethods.size()]);
    }

    public void privateRun(XmlTest xmlTest) {
        Map<String, String> params = xmlTest.getParameters();
        ArrayList<List<ITestNGMethod>> sequentialList = new ArrayList<List<ITestNGMethod>>();
        ArrayList<ITestNGMethod> parallelList = new ArrayList<ITestNGMethod>();
        this.computeTestLists(sequentialList, parallelList);
        this.log(3, new StringBuffer().append("Found ").append(sequentialList.size() + parallelList.size()).append(" applicable methods").toString());
        ArrayList<TestMethodWorker> workers = new ArrayList<TestMethodWorker>();
        HashMap<ITestClass, ITestClass> beforeClassMethods = new HashMap<ITestClass, ITestClass>();
        HashMap<ITestClass, ITestClass> afterClassMethods = new HashMap<ITestClass, ITestClass>();
        ClassMethodMap cmm = new ClassMethodMap(this.m_allTestMethods);
        if (sequentialList.size() > 0) {
            for (List list : sequentialList) {
                workers.add(new TestMethodWorker(this.m_invoker, this.methodsToMethodInstances(list), this.m_xmlTest.getSuite(), params, beforeClassMethods, afterClassMethods, this.m_allTestMethods, this.m_groupMethods, cmm, this));
            }
        }
        if (parallelList.size() > 0) {
            for (ITestNGMethod iTestNGMethod : parallelList) {
                MethodInstance[] methodInstances;
                for (MethodInstance mi : methodInstances = this.methodsToMultipleMethodInstances(Arrays.asList(iTestNGMethod))) {
                    workers.add(new TestMethodWorker(this.m_invoker, new MethodInstance[]{mi}, this.m_xmlTest.getSuite(), params, beforeClassMethods, afterClassMethods, this.m_allTestMethods, this.m_groupMethods, cmm, this));
                }
            }
        }
        this.runWorkers(workers, xmlTest.getParallel());
    }

    private MethodInstance[] methodsToMultipleMethodInstances(List<ITestNGMethod> sl) {
        ArrayList<MethodInstance> vResult = new ArrayList<MethodInstance>();
        for (ITestNGMethod m : sl) {
            Object[] instances;
            for (Object instance : instances = m.getTestClass().getInstances(true)) {
                vResult.add(new MethodInstance(m, new Object[]{instance}));
            }
        }
        MethodInstance[] result = vResult.toArray(new MethodInstance[vResult.size()]);
        return result;
    }

    private MethodInstance[] methodsToMethodInstances(List<ITestNGMethod> sl) {
        MethodInstance[] result = new MethodInstance[sl.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new MethodInstance(sl.get(i), sl.get(i).getTestClass().getInstances(true));
        }
        return result;
    }

    private void runWorkers(List<? extends IMethodWorker> workers, String parallelMode) {
        if ("methods".equals(parallelMode) || "true".equalsIgnoreCase(parallelMode) || "tests".equals(parallelMode)) {
            long maxTimeOut = this.m_xmlTest.getTimeOut(10000L);
            for (IMethodWorker iMethodWorker : workers) {
                long mt = iMethodWorker.getMaxTimeOut();
                if (mt <= maxTimeOut) continue;
                maxTimeOut = mt;
            }
            ThreadUtil.execute(workers, this.m_xmlTest.getThreadCount(), maxTimeOut, false);
        } else {
            for (IMethodWorker iMethodWorker : workers) {
                iMethodWorker.run();
            }
        }
    }

    private void afterRun() {
        ITestNGMethod[] testConfigurationMethods = this.getAfterTestConfigurationMethods();
        if (null != testConfigurationMethods && testConfigurationMethods.length > 0) {
            this.m_invoker.invokeConfigurations(null, testConfigurationMethods, this.m_xmlTest.getSuite(), this.m_xmlTest.getParameters(), null);
        }
        this.m_endDate = new Date(System.currentTimeMillis());
        if (TestRunner.getVerbose() >= 3) {
            this.dumpInvokedMethods();
        }
        this.fireEvent(false);
    }

    private boolean containsString(Map<String, String> regexps, String group) {
        for (String regexp : regexps.values()) {
            boolean match = Pattern.matches(regexp, group);
            if (!match) continue;
            return true;
        }
        return false;
    }

    private void computeTestLists(List<List<ITestNGMethod>> sl, List<ITestNGMethod> parallelList) {
        HashMap<String, String> groupsDependedUpon = new HashMap<String, String>();
        HashMap<String, String> methodsDependedUpon = new HashMap<String, String>();
        HashMap<String, ArrayList<ITestNGMethod>> sequentialAttributeList = new HashMap<String, ArrayList<ITestNGMethod>>();
        ArrayList<ITestNGMethod> sequentialList = new ArrayList<ITestNGMethod>();
        for (int i = this.m_allTestMethods.length - 1; i >= 0; --i) {
            int i$;
            ITestNGMethod iTestNGMethod = this.m_allTestMethods[i];
            Class<?> cls = iTestNGMethod.getMethod().getDeclaringClass();
            ITest test = (ITest)this.m_annotationFinder.findAnnotation(cls, class$org$testng$internal$annotations$ITest == null ? TestRunner.class$("org.testng.internal.annotations.ITest") : class$org$testng$internal$annotations$ITest);
            if (test != null && test.getSequential()) {
                String className = cls.getName();
                ArrayList<ITestNGMethod> list = (ArrayList<ITestNGMethod>)sequentialAttributeList.get(className);
                if (list == null) {
                    list = new ArrayList<ITestNGMethod>();
                    sequentialAttributeList.put(className, list);
                }
                list.add(0, iTestNGMethod);
                continue;
            }
            String[] currentGroups = iTestNGMethod.getGroups();
            String[] currentGroupsDependedUpon = iTestNGMethod.getGroupsDependedUpon();
            String[] currentMethodsDependedUpon = iTestNGMethod.getMethodsDependedUpon();
            String thisMethodName = new StringBuffer().append(iTestNGMethod.getMethod().getDeclaringClass().getName()).append(".").append(iTestNGMethod.getMethod().getName()).toString();
            if (currentGroupsDependedUpon.length > 0) {
                String[] arr$ = currentGroupsDependedUpon;
                int len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    String gdu = arr$[i$];
                    groupsDependedUpon.put(gdu, gdu);
                }
                sequentialList.add(0, iTestNGMethod);
                continue;
            }
            if (currentMethodsDependedUpon.length > 0) {
                String[] arr$ = currentMethodsDependedUpon;
                int len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    String cmu = arr$[i$];
                    methodsDependedUpon.put(cmu, cmu);
                }
                sequentialList.add(0, iTestNGMethod);
                continue;
            }
            if (this.containsString(methodsDependedUpon, thisMethodName)) {
                sequentialList.add(0, iTestNGMethod);
                continue;
            }
            if (currentGroups.length > 0) {
                boolean isSequential = false;
                for (String group : currentGroups) {
                    if (!this.containsString(groupsDependedUpon, group)) continue;
                    sequentialList.add(0, iTestNGMethod);
                    isSequential = true;
                    break;
                }
                if (isSequential) continue;
                parallelList.add(0, iTestNGMethod);
                continue;
            }
            parallelList.add(0, iTestNGMethod);
        }
        if (sequentialList.size() > 0) {
            sl.add(sequentialList);
        }
        for (List list : sequentialAttributeList.values()) {
            sl.add(list);
        }
        Collections.sort(parallelList, TestNGMethod.SORT_BY_CLASS);
        if (TestRunner.getVerbose() >= 2) {
            this.log(3, "WILL BE RUN IN RANDOM ORDER:");
            for (ITestNGMethod iTestNGMethod : parallelList) {
                this.log(3, new StringBuffer().append("  ").append(iTestNGMethod).toString());
            }
            this.log(3, "WILL BE RUN SEQUENTIALLY:");
            for (List list : sl) {
                for (ITestNGMethod tm : list) {
                    this.log(3, new StringBuffer().append("  ").append(tm).toString());
                }
                this.log(3, "====");
            }
            this.log(3, "===");
        }
    }

    private void logStart() {
        this.log(3, new StringBuffer().append("Running test ").append(this.m_testName).append(" on ").append(this.m_classMap.size()).append(" ").append(" classes, ").append(" included groups:[").append(this.mapToString(this.m_xmlMethodSelector.getIncludedGroups())).append("] excluded groups:[").append(this.mapToString(this.m_xmlMethodSelector.getExcludedGroups())).append("]").toString());
        if (TestRunner.getVerbose() >= 3) {
            for (ITestClass tc : this.m_classMap.values()) {
                ((TestClass)tc).dump();
            }
        }
    }

    private void fireEvent(boolean isStart) {
        for (ITestListener itl : this.m_testListeners) {
            if (isStart) {
                itl.onStart(this);
                continue;
            }
            itl.onFinish(this);
        }
    }

    @Override
    public String getName() {
        return this.m_testName;
    }

    @Override
    public Date getStartDate() {
        return this.m_startDate;
    }

    @Override
    public Date getEndDate() {
        return this.m_endDate;
    }

    @Override
    public IResultMap getPassedTests() {
        return this.m_passedTests;
    }

    @Override
    public IResultMap getSkippedTests() {
        return this.m_skippedTests;
    }

    @Override
    public IResultMap getFailedTests() {
        return this.m_failedTests;
    }

    @Override
    public IResultMap getFailedButWithinSuccessPercentageTests() {
        return this.m_failedButWithinSuccessPercentageTests;
    }

    @Override
    public String[] getIncludedGroups() {
        Map<String, String> ig = this.m_xmlMethodSelector.getIncludedGroups();
        String[] result = ig.values().toArray(new String[ig.size()]);
        return result;
    }

    @Override
    public String[] getExcludedGroups() {
        Map<String, String> eg = this.m_xmlMethodSelector.getExcludedGroups();
        String[] result = eg.values().toArray(new String[eg.size()]);
        return result;
    }

    @Override
    public String getOutputDirectory() {
        return this.m_outputDirectory;
    }

    @Override
    public ISuite getSuite() {
        return this.m_suite;
    }

    @Override
    public ITestNGMethod[] getAllTestMethods() {
        return this.m_allTestMethods;
    }

    @Override
    public String getHost() {
        return this.m_host;
    }

    @Override
    public Collection<ITestNGMethod> getExcludedMethods() {
        HashMap<ITestNGMethod, ITestNGMethod> vResult = new HashMap<ITestNGMethod, ITestNGMethod>();
        for (ITestNGMethod m : this.m_excludedMethods) {
            vResult.put(m, m);
        }
        return vResult.keySet();
    }

    @Override
    public IResultMap getFailedConfigurations() {
        return this.m_failedConfigurations;
    }

    @Override
    public IResultMap getPassedConfigurations() {
        return this.m_passedConfigurations;
    }

    @Override
    public IResultMap getSkippedConfigurations() {
        return this.m_skippedConfigurations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPassedTest(ITestNGMethod tm, ITestResult tr) {
        IResultMap iResultMap = this.m_passedTests;
        synchronized (iResultMap) {
            this.m_passedTests.addResult(tr, tm);
        }
    }

    @Override
    public Set<ITestResult> getPassedTests(ITestNGMethod tm) {
        return this.m_passedTests.getResults(tm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSkippedTest(ITestNGMethod tm, ITestResult tr) {
        IResultMap iResultMap = this.m_skippedTests;
        synchronized (iResultMap) {
            this.m_skippedTests.addResult(tr, tm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInvokedMethod(InvokedMethod im) {
        List<InvokedMethod> list = this.m_invokedMethods;
        synchronized (list) {
            this.m_invokedMethods.add(im);
        }
    }

    @Override
    public void addFailedTest(ITestNGMethod testMethod, ITestResult result) {
        this.logFailedTest(testMethod, result, false);
    }

    @Override
    public void addFailedButWithinSuccessPercentageTest(ITestNGMethod testMethod, ITestResult result) {
        this.logFailedTest(testMethod, result, true);
    }

    @Override
    public XmlTest getTest() {
        return this.m_xmlTest;
    }

    @Override
    public List<ITestListener> getTestListeners() {
        return this.m_testListeners;
    }

    @Override
    public List<IConfigurationListener> getConfigurationListeners() {
        return this.m_configurationListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logFailedTest(ITestNGMethod method, ITestResult tr, boolean withinSuccessPercentage) {
        if (withinSuccessPercentage) {
            IResultMap iResultMap = this.m_failedButWithinSuccessPercentageTests;
            synchronized (iResultMap) {
                this.m_failedButWithinSuccessPercentageTests.addResult(tr, method);
            }
        }
        IResultMap iResultMap = this.m_failedTests;
        synchronized (iResultMap) {
            this.m_failedTests.addResult(tr, method);
        }
    }

    private String mapToString(Map m) {
        StringBuffer result = new StringBuffer();
        for (Object o : m.values()) {
            result.append(o.toString()).append(" ");
        }
        return result.toString();
    }

    private void log(int level, String s) {
        Utils.log("TestRunner", level, s);
    }

    public static int getVerbose() {
        return m_verbose;
    }

    public void setVerbose(int n) {
        m_verbose = n;
    }

    private void log(String s) {
        Utils.log("TestRunner", 2, s);
    }

    public void addListener(Object listener) {
        if (listener instanceof ITestListener) {
            this.addTestListener((ITestListener)listener);
        }
        if (listener instanceof IConfigurationListener) {
            this.addConfigurationListener((IConfigurationListener)listener);
        }
    }

    public void addTestListener(ITestListener il) {
        this.m_testListeners.add(il);
    }

    public void addConfigurationListener(IConfigurationListener icl) {
        this.m_configurationListeners.add(icl);
    }

    private void dumpInvokedMethods() {
        System.out.println("\n*********** INVOKED METHODS\n");
        for (InvokedMethod im : this.m_invokedMethods) {
            if (im.isTestMethod()) {
                System.out.print("\t\t");
            } else {
                if (!im.isConfigurationMethod()) continue;
                System.out.print("\t");
            }
            System.out.println(new StringBuffer().append("").append(im).toString());
        }
        System.out.println("\n***********\n");
    }

    public List<ITestNGMethod> getInvokedMethods() {
        ArrayList<ITestNGMethod> result = new ArrayList<ITestNGMethod>();
        for (InvokedMethod im : this.m_invokedMethods) {
            ITestNGMethod tm = im.getTestMethod();
            tm.setDate(im.getDate());
            result.add(tm);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    private class ConfigurationListener
    implements IConfigurationListener {
        private ConfigurationListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConfigurationFailure(ITestResult itr) {
            IResultMap iResultMap = TestRunner.this.m_failedConfigurations;
            synchronized (iResultMap) {
                TestRunner.this.m_failedConfigurations.addResult(itr, itr.getMethod());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConfigurationSkip(ITestResult itr) {
            IResultMap iResultMap = TestRunner.this.m_skippedConfigurations;
            synchronized (iResultMap) {
                TestRunner.this.m_skippedConfigurations.addResult(itr, itr.getMethod());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConfigurationSuccess(ITestResult itr) {
            IResultMap iResultMap = TestRunner.this.m_passedConfigurations;
            synchronized (iResultMap) {
                TestRunner.this.m_passedConfigurations.addResult(itr, itr.getMethod());
            }
        }
    }
}

