/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.testng.IClass;
import org.testng.ITestClass;
import org.testng.ITestMethodFinder;
import org.testng.ITestNGMethod;
import org.testng.internal.ConfigurationMethod;
import org.testng.internal.NoOpTestClass;
import org.testng.internal.RunInfo;
import org.testng.internal.TestNGMethod;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;

public class TestClass
extends NoOpTestClass
implements ITestClass {
    private static final long serialVersionUID = -8077917128278361294L;
    private transient IAnnotationFinder m_annotationFinder = null;
    private transient ITestMethodFinder m_testMethodFinder = null;
    protected transient Map<Class, Class> m_testClasses = new HashMap<Class, Class>();
    protected transient Map<Class, Object[]> m_instanceMap = new HashMap<Class, Object[]>();
    private IClass m_iClass = null;
    private RunInfo m_runInfo = null;

    public TestClass(IClass cls, String testName, ITestMethodFinder testMethodFinder, IAnnotationFinder annotationFinder, RunInfo runInfo) {
        this.init(cls, testName, testMethodFinder, annotationFinder, runInfo);
    }

    public TestClass(IClass cls, TestClass tc) {
        this.init(cls, tc.getTestName(), tc.getTestMethodFinder(), tc.getAnnotationFinder(), tc.getRunInfo());
    }

    public String getTestName() {
        return this.m_testName;
    }

    public IAnnotationFinder getAnnotationFinder() {
        return this.m_annotationFinder;
    }

    private void init(IClass cls, String testName, ITestMethodFinder testMethodFinder, IAnnotationFinder annotationFinder, RunInfo runInfo) {
        this.log(3, "Creating TestClass for " + cls);
        this.m_iClass = cls;
        this.m_testClass = cls.getRealClass();
        this.m_testName = testName;
        this.m_runInfo = runInfo;
        this.m_testMethodFinder = testMethodFinder;
        this.m_annotationFinder = annotationFinder;
        this.initMethods();
        this.initTestClassesAndInstances();
    }

    private void initTestClassesAndInstances() {
        Object[] instances;
        Object[] arr$ = instances = this.getInstances(false);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Object instance = arr$[i$];
            Class<?> cls = instance.getClass();
            if (null != this.m_testClasses.get(cls)) continue;
            this.m_testClasses.put(cls, cls);
            this.m_instanceMap.put(cls, instances);
        }
    }

    public Object[] getInstances(boolean create) {
        return this.m_iClass.getInstances(create);
    }

    public long[] getInstanceHashCodes() {
        return this.m_iClass.getInstanceHashCodes();
    }

    public int getInstanceCount() {
        return this.m_iClass.getInstanceCount();
    }

    public void addInstance(Object instance) {
        this.m_iClass.addInstance(instance);
    }

    private void initMethods() {
        ITestNGMethod[] methods = this.m_testMethodFinder.getTestMethods(this.m_testClass);
        this.m_testMethods = this.createTestMethods(methods);
        this.m_beforeSuiteMethods = ConfigurationMethod.createSuiteConfigurationMethods(this.m_testMethodFinder.getBeforeSuiteMethods(this.m_testClass), this.m_annotationFinder, true);
        this.m_afterSuiteMethods = ConfigurationMethod.createSuiteConfigurationMethods(this.m_testMethodFinder.getAfterSuiteMethods(this.m_testClass), this.m_annotationFinder, false);
        this.m_beforeTestConfMethods = ConfigurationMethod.createTestConfigurationMethods(this.m_testMethodFinder.getBeforeTestConfigurationMethods(this.m_testClass), this.m_annotationFinder, true);
        this.m_afterTestConfMethods = ConfigurationMethod.createTestConfigurationMethods(this.m_testMethodFinder.getAfterTestConfigurationMethods(this.m_testClass), this.m_annotationFinder, false);
        this.m_beforeClassMethods = ConfigurationMethod.createClassConfigurationMethods(this.m_testMethodFinder.getBeforeClassMethods(this.m_testClass), this.m_annotationFinder, true);
        this.m_afterClassMethods = ConfigurationMethod.createClassConfigurationMethods(this.m_testMethodFinder.getAfterClassMethods(this.m_testClass), this.m_annotationFinder, false);
        this.m_beforeGroupsMethods = ConfigurationMethod.createBeforeConfigurationMethods(this.m_testMethodFinder.getBeforeGroupsConfigurationMethods(this.m_testClass), this.m_annotationFinder, true);
        this.m_afterGroupsMethods = ConfigurationMethod.createAfterConfigurationMethods(this.m_testMethodFinder.getAfterGroupsConfigurationMethods(this.m_testClass), this.m_annotationFinder, false);
        this.m_beforeTestMethods = ConfigurationMethod.createTestMethodConfigurationMethods(this.m_testMethodFinder.getBeforeTestMethods(this.m_testClass), this.m_annotationFinder, true);
        this.m_afterTestMethods = ConfigurationMethod.createTestMethodConfigurationMethods(this.m_testMethodFinder.getAfterTestMethods(this.m_testClass), this.m_annotationFinder, false);
    }

    private ITestNGMethod[] createTestMethods(ITestNGMethod[] methods) {
        ArrayList<TestNGMethod> vResult = new ArrayList<TestNGMethod>();
        ITestNGMethod[] arr$ = methods;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ITestNGMethod tm = arr$[i$];
            Method m = tm.getMethod();
            if (m.getDeclaringClass().isAssignableFrom(this.m_testClass)) {
                this.log(4, "Adding method " + tm + " on TestClass " + this.m_testClass);
                vResult.add(new TestNGMethod(m, this.m_annotationFinder));
                continue;
            }
            this.log(4, "Rejecting method " + tm + " for TestClass " + this.m_testClass);
        }
        ITestNGMethod[] result = vResult.toArray(new ITestNGMethod[vResult.size()]);
        return result;
    }

    private RunInfo getRunInfo() {
        return this.m_runInfo;
    }

    public ITestMethodFinder getTestMethodFinder() {
        return this.m_testMethodFinder;
    }

    private void log(int level, String s) {
        Utils.log("TestClass", level, s);
    }

    private static void ppp(String s) {
        System.out.println("[TestClass] " + s);
    }

    public void dump() {
        ITestNGMethod m;
        int i$;
        TestClass.ppp("\n======\nTESTCLASS: " + this.m_testClass.getName());
        ITestNGMethod[] arr$ = this.m_beforeClassMethods;
        int len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            m = arr$[i$];
            TestClass.ppp("BeforeClass : " + m);
        }
        arr$ = this.m_beforeTestMethods;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            m = arr$[i$];
            TestClass.ppp("BeforeMethod:\t" + m);
        }
        arr$ = this.m_testMethods;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            m = arr$[i$];
            TestClass.ppp("Test        :\t\t" + m);
        }
        arr$ = this.m_afterTestMethods;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            m = arr$[i$];
            TestClass.ppp("AfterMethod :\t" + m);
        }
        arr$ = this.m_afterClassMethods;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            m = arr$[i$];
            TestClass.ppp("AfterClass  : " + m);
        }
        TestClass.ppp("\n======\n");
    }

    public String toString() {
        return "[TestClass " + this.m_testClass + "]";
    }
}

