/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.impl;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.ftpserver.DataConnectionConfiguration;
import org.apache.ftpserver.DataConnectionException;
import org.apache.ftpserver.ftplet.DataConnection;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.impl.IODataConnection;
import org.apache.ftpserver.impl.ServerDataConnectionFactory;
import org.apache.ftpserver.ssl.ClientAuth;
import org.apache.ftpserver.ssl.SslConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IODataConnectionFactory
implements ServerDataConnectionFactory {
    private final Logger LOG = LoggerFactory.getLogger(IODataConnectionFactory.class);
    private FtpServerContext serverContext;
    private Socket dataSoc;
    ServerSocket servSoc;
    InetAddress address;
    int port = 0;
    long requestTime = 0L;
    boolean passive = false;
    boolean secure = false;
    private boolean isZip = false;
    InetAddress serverControlAddress;
    FtpIoSession session;

    public IODataConnectionFactory(FtpServerContext serverContext, FtpIoSession session) {
        this.session = session;
        this.serverContext = serverContext;
        if (session != null && session.getListener() != null && session.getListener().getDataConnectionConfiguration().isImplicitSsl()) {
            this.secure = true;
        }
    }

    public synchronized void closeDataConnection() {
        if (this.dataSoc != null) {
            try {
                this.dataSoc.close();
            }
            catch (Exception ex) {
                this.LOG.warn("FtpDataConnection.closeDataSocket()", (Throwable)ex);
            }
            this.dataSoc = null;
        }
        if (this.servSoc != null) {
            DataConnectionConfiguration dcc;
            try {
                this.servSoc.close();
            }
            catch (Exception ex) {
                this.LOG.warn("FtpDataConnection.closeDataSocket()", (Throwable)ex);
            }
            if (this.session != null && (dcc = this.session.getListener().getDataConnectionConfiguration()) != null) {
                dcc.releasePassivePort(this.port);
            }
            this.servSoc = null;
        }
        this.requestTime = 0L;
    }

    @Override
    public synchronized void initActiveDataConnection(InetSocketAddress address) {
        this.closeDataConnection();
        this.passive = false;
        this.address = address.getAddress();
        this.port = address.getPort();
        this.requestTime = System.currentTimeMillis();
    }

    private SslConfiguration getSslConfiguration() {
        DataConnectionConfiguration dataCfg = this.session.getListener().getDataConnectionConfiguration();
        SslConfiguration configuration = dataCfg.getSslConfiguration();
        if (configuration == null) {
            configuration = this.session.getListener().getSslConfiguration();
        }
        return configuration;
    }

    @Override
    public synchronized InetSocketAddress initPassiveDataConnection() throws DataConnectionException {
        this.LOG.debug("Initiating passive data connection");
        this.closeDataConnection();
        int passivePort = this.session.getListener().getDataConnectionConfiguration().requestPassivePort();
        if (passivePort == -1) {
            this.servSoc = null;
            throw new DataConnectionException("Cannot find an available passive port.");
        }
        try {
            DataConnectionConfiguration dataCfg = this.session.getListener().getDataConnectionConfiguration();
            String passiveAddress = dataCfg.getPassiveAddress();
            this.address = passiveAddress == null ? this.serverControlAddress : this.resolveAddress(dataCfg.getPassiveAddress());
            if (this.secure) {
                this.LOG.debug("Opening SSL passive data connection on address \"{}\" and port {}", (Object)this.address, (Object)passivePort);
                SslConfiguration ssl = this.getSslConfiguration();
                if (ssl == null) {
                    throw new DataConnectionException("Data connection SSL required but not configured.");
                }
                this.servSoc = new ServerSocket(passivePort, 0, this.address);
                this.LOG.debug("SSL Passive data connection created on address \"{}\" and port {}", (Object)this.address, (Object)passivePort);
            } else {
                this.LOG.debug("Opening passive data connection on address \"{}\" and port {}", (Object)this.address, (Object)passivePort);
                this.servSoc = new ServerSocket(passivePort, 0, this.address);
                this.LOG.debug("Passive data connection created on address \"{}\" and port {}", (Object)this.address, (Object)passivePort);
            }
            this.port = this.servSoc.getLocalPort();
            this.servSoc.setSoTimeout(dataCfg.getIdleTime() * 1000);
            this.passive = true;
            this.requestTime = System.currentTimeMillis();
            return new InetSocketAddress(this.address, this.port);
        }
        catch (Exception ex) {
            this.closeDataConnection();
            throw new DataConnectionException("Failed to initate passive data connection: " + ex.getMessage(), ex);
        }
    }

    @Override
    public InetAddress getInetAddress() {
        return this.address;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public DataConnection openConnection() throws Exception {
        return new IODataConnection(this.createDataSocket(), this.session, this);
    }

    private synchronized Socket createDataSocket() throws Exception {
        this.dataSoc = null;
        DataConnectionConfiguration dataConfig = this.session.getListener().getDataConnectionConfiguration();
        try {
            if (!this.passive) {
                if (this.secure) {
                    this.LOG.debug("Opening secure active data connection");
                    SslConfiguration ssl = this.getSslConfiguration();
                    if (ssl == null) {
                        throw new FtpException("Data connection SSL not configured");
                    }
                    SSLSocketFactory socFactory = ssl.getSocketFactory();
                    SSLSocket ssoc = (SSLSocket)socFactory.createSocket();
                    ssoc.setUseClientMode(false);
                    if (ssl.getEnabledCipherSuites() != null) {
                        ssoc.setEnabledCipherSuites(ssl.getEnabledCipherSuites());
                    }
                    if (ssl.getEnabledProtocol() != null) {
                        ssoc.setEnabledProtocols(new String[]{ssl.getEnabledProtocol()});
                    }
                    this.dataSoc = ssoc;
                } else {
                    this.LOG.debug("Opening active data connection");
                    this.dataSoc = new Socket();
                }
                this.dataSoc.setReuseAddress(true);
                InetAddress localAddr = this.resolveAddress(dataConfig.getActiveLocalAddress());
                if (localAddr == null) {
                    localAddr = ((InetSocketAddress)this.session.getLocalAddress()).getAddress();
                }
                InetSocketAddress localSocketAddress = new InetSocketAddress(localAddr, dataConfig.getActiveLocalPort());
                this.LOG.debug("Binding active data connection to {}", (Object)localSocketAddress);
                this.dataSoc.bind(localSocketAddress);
                this.dataSoc.connect(new InetSocketAddress(this.address, this.port));
            } else {
                if (this.secure) {
                    this.LOG.debug("Opening secure passive data connection");
                    SslConfiguration ssl = this.getSslConfiguration();
                    if (ssl == null) {
                        throw new FtpException("Data connection SSL not configured");
                    }
                    SSLSocketFactory ssocketFactory = ssl.getSocketFactory();
                    Socket serverSocket = this.servSoc.accept();
                    SSLSocket sslSocket = (SSLSocket)ssocketFactory.createSocket(serverSocket, serverSocket.getInetAddress().getHostAddress(), serverSocket.getPort(), true);
                    sslSocket.setUseClientMode(false);
                    if (ssl.getClientAuth() == ClientAuth.NEED) {
                        sslSocket.setNeedClientAuth(true);
                    } else if (ssl.getClientAuth() == ClientAuth.WANT) {
                        sslSocket.setWantClientAuth(true);
                    }
                    if (ssl.getEnabledCipherSuites() != null) {
                        sslSocket.setEnabledCipherSuites(ssl.getEnabledCipherSuites());
                    }
                    if (ssl.getEnabledProtocol() != null) {
                        sslSocket.setEnabledProtocols(new String[]{ssl.getEnabledProtocol()});
                    }
                    this.dataSoc = sslSocket;
                } else {
                    this.LOG.debug("Opening passive data connection");
                    this.dataSoc = this.servSoc.accept();
                }
                if (dataConfig.isPassiveIpCheck()) {
                    InetAddress remoteAddress = ((InetSocketAddress)this.session.getRemoteAddress()).getAddress();
                    InetAddress dataSocketAddress = this.dataSoc.getInetAddress();
                    if (!dataSocketAddress.equals(remoteAddress)) {
                        this.LOG.warn("Passive IP Check failed. Closing data connection from " + dataSocketAddress + " as it does not match the expected address " + remoteAddress);
                        this.closeDataConnection();
                        return null;
                    }
                }
                DataConnectionConfiguration dataCfg = this.session.getListener().getDataConnectionConfiguration();
                this.dataSoc.setSoTimeout(dataCfg.getIdleTime() * 1000);
                this.LOG.debug("Passive data connection opened");
            }
        }
        catch (Exception ex) {
            this.closeDataConnection();
            this.LOG.warn("FtpDataConnection.getDataSocket()", (Throwable)ex);
            throw ex;
        }
        this.dataSoc.setSoTimeout(dataConfig.getIdleTime() * 1000);
        if (this.dataSoc instanceof SSLSocket) {
            ((SSLSocket)this.dataSoc).startHandshake();
        }
        return this.dataSoc;
    }

    private InetAddress resolveAddress(String host) throws DataConnectionException {
        if (host == null) {
            return null;
        }
        try {
            return InetAddress.getByName(host);
        }
        catch (UnknownHostException ex) {
            throw new DataConnectionException("Failed to resolve address", ex);
        }
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @Override
    public boolean isZipMode() {
        return this.isZip;
    }

    @Override
    public void setZipMode(boolean zip) {
        this.isZip = zip;
    }

    @Override
    public synchronized boolean isTimeout(long currTime) {
        if (this.requestTime == 0L) {
            return false;
        }
        if (this.dataSoc != null) {
            return false;
        }
        int maxIdleTime = this.session.getListener().getDataConnectionConfiguration().getIdleTime() * 1000;
        if (maxIdleTime == 0) {
            return false;
        }
        return currTime - this.requestTime >= (long)maxIdleTime;
    }

    @Override
    public void dispose() {
        this.closeDataConnection();
    }

    @Override
    public void setServerControlAddress(InetAddress serverControlAddress) {
        this.serverControlAddress = serverControlAddress;
    }
}

