/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMessageChannel.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSMessagePort.h"
#include "MessageChannel.h"
#include "MessagePort.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSMessageChannelTableValues[] =
{
    { "port1", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMessageChannelPort1), (intptr_t)0, NoIntrinsic },
    { "port2", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMessageChannelPort2), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMessageChannelConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMessageChannelTable = { 8, 7, JSMessageChannelTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSMessageChannelConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMessageChannelConstructorTable = { 1, 0, JSMessageChannelConstructorTableValues, 0 };
static const HashTable* getJSMessageChannelConstructorTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSMessageChannelConstructorTable);
}

const ClassInfo JSMessageChannelConstructor::s_info = { "MessageChannelConstructor", &Base::s_info, 0, getJSMessageChannelConstructorTable, CREATE_METHOD_TABLE(JSMessageChannelConstructor) };

JSMessageChannelConstructor::JSMessageChannelConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSMessageChannelConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSMessageChannelPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->globalData(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSMessageChannelConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMessageChannelConstructor, JSDOMWrapper>(exec, getJSMessageChannelConstructorTable(exec), jsCast<JSMessageChannelConstructor*>(cell), propertyName, slot);
}

bool JSMessageChannelConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSMessageChannelConstructor, JSDOMWrapper>(exec, getJSMessageChannelConstructorTable(exec), jsCast<JSMessageChannelConstructor*>(object), propertyName, descriptor);
}

EncodedJSValue JSC_HOST_CALL JSMessageChannelConstructor::constructJSMessageChannel(ExecState* exec)
{
    JSMessageChannelConstructor* castedThis = jsCast<JSMessageChannelConstructor*>(exec->callee());
    ScriptExecutionContext* context = castedThis->scriptExecutionContext();
    if (!context)
        return throwVMError(exec, createReferenceError(exec, "MessageChannel constructor associated document is unavailable"));
    RefPtr<MessageChannel> object = MessageChannel::create(context);
    return JSValue::encode(asObject(toJS(exec, castedThis->globalObject(), object.get())));
}

ConstructType JSMessageChannelConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSMessageChannel;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSMessageChannelPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMessageChannelPrototypeTable = { 1, 0, JSMessageChannelPrototypeTableValues, 0 };
static const HashTable* getJSMessageChannelPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSMessageChannelPrototypeTable);
}

const ClassInfo JSMessageChannelPrototype::s_info = { "MessageChannelPrototype", &Base::s_info, 0, getJSMessageChannelPrototypeTable, CREATE_METHOD_TABLE(JSMessageChannelPrototype) };

JSObject* JSMessageChannelPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMessageChannel>(exec, globalObject);
}

static const HashTable* getJSMessageChannelTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSMessageChannelTable);
}

const ClassInfo JSMessageChannel::s_info = { "MessageChannel", &Base::s_info, 0, getJSMessageChannelTable , CREATE_METHOD_TABLE(JSMessageChannel) };

JSMessageChannel::JSMessageChannel(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<MessageChannel> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSMessageChannel::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSMessageChannel::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSMessageChannelPrototype::create(exec->globalData(), globalObject, JSMessageChannelPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSMessageChannel::destroy(JSC::JSCell* cell)
{
    JSMessageChannel* thisObject = static_cast<JSMessageChannel*>(cell);
    thisObject->JSMessageChannel::~JSMessageChannel();
}

JSMessageChannel::~JSMessageChannel()
{
    releaseImplIfNotNull();
}

bool JSMessageChannel::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSMessageChannel* thisObject = jsCast<JSMessageChannel*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSMessageChannel, Base>(exec, getJSMessageChannelTable(exec), thisObject, propertyName, slot);
}

bool JSMessageChannel::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSMessageChannel* thisObject = jsCast<JSMessageChannel*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSMessageChannel, Base>(exec, getJSMessageChannelTable(exec), thisObject, propertyName, descriptor);
}

JSValue jsMessageChannelPort1(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMessageChannel* castedThis = jsCast<JSMessageChannel*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MessageChannel* impl = static_cast<MessageChannel*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->port1()));
    return result;
}


JSValue jsMessageChannelPort2(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMessageChannel* castedThis = jsCast<JSMessageChannel*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MessageChannel* impl = static_cast<MessageChannel*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->port2()));
    return result;
}


JSValue jsMessageChannelConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMessageChannel* domObject = jsCast<JSMessageChannel*>(asObject(slotBase));
    return JSMessageChannel::getConstructor(exec, domObject->globalObject());
}

JSValue JSMessageChannel::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMessageChannelConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

static inline bool isObservable(JSMessageChannel* jsMessageChannel)
{
    if (jsMessageChannel->hasCustomProperties())
        return true;
    return false;
}

bool JSMessageChannelOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSMessageChannel* jsMessageChannel = jsCast<JSMessageChannel*>(handle.get().asCell());
    if (!isObservable(jsMessageChannel))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSMessageChannelOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSMessageChannel* jsMessageChannel = jsCast<JSMessageChannel*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsMessageChannel->impl(), jsMessageChannel);
    jsMessageChannel->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, MessageChannel* impl)
{
    return wrap<JSMessageChannel>(exec, globalObject, impl);
}

MessageChannel* toMessageChannel(JSC::JSValue value)
{
    return value.inherits(&JSMessageChannel::s_info) ? jsCast<JSMessageChannel*>(asObject(value))->impl() : 0;
}

}
